/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.robotic_arm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MoveSpeedLevel implements Enumerator
{
    SLOW(0, "SLOW", "SLOW"),
    MEDIUM(1, "MEDIUM", "MEDIUM"),
    FAST(2, "FAST", "FAST");

    public static final int SLOW_VALUE = 0;
    public static final int MEDIUM_VALUE = 1;
    public static final int FAST_VALUE = 2;
    private static final MoveSpeedLevel[] VALUES_ARRAY;
    public static final List<MoveSpeedLevel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MoveSpeedLevel[]{SLOW, MEDIUM, FAST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MoveSpeedLevel get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MoveSpeedLevel result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MoveSpeedLevel getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MoveSpeedLevel result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MoveSpeedLevel get(int value) {
        switch (value) {
            case 0: {
                return SLOW;
            }
            case 1: {
                return MEDIUM;
            }
            case 2: {
                return FAST;
            }
        }
        return null;
    }

    private MoveSpeedLevel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

