/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import javax.measure.unit.Unit;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class NativeToDisplayUnitsMapComposite
extends Composite {
    private Table table = null;
    private Button addButton = null;
    private Button deleteButton = null;

    public NativeToDisplayUnitsMapComposite(Composite parent, int style) {
        super(parent, style);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.pack = true;
        rowLayout.fill = false;
        rowLayout.center = true;
        this.setLayout((Layout)rowLayout);
        Composite buttonsComposite = new Composite((Composite)this, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(2, false));
        RowData buttonsCompositeRowData = new RowData();
        buttonsCompositeRowData.height = 37;
        buttonsComposite.setLayoutData((Object)buttonsCompositeRowData);
        this.addButton = new Button(buttonsComposite, 8);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = new TableItem(NativeToDisplayUnitsMapComposite.this.table, 0);
                item.setText(0, "?");
                item.setText(1, "?");
                NativeToDisplayUnitsMapComposite.this.validate(item, "?", "?");
                NativeToDisplayUnitsMapComposite.this.table.select(NativeToDisplayUnitsMapComposite.this.table.getItemCount());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.deleteButton = new Button(buttonsComposite, 8);
        this.deleteButton.setText("Delete");
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NativeToDisplayUnitsMapComposite.this.table.remove(NativeToDisplayUnitsMapComposite.this.table.getSelectionIndices());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table = this.createTable(this);
        RowData tableRowData = new RowData();
        tableRowData.height = 137;
        this.table.setLayoutData((Object)tableRowData);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (NativeToDisplayUnitsMapComposite.this.table.getSelectionIndices().length > 0) {
                    NativeToDisplayUnitsMapComposite.this.deleteButton.setEnabled(true);
                } else {
                    NativeToDisplayUnitsMapComposite.this.deleteButton.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public Map<String, String> getNativeToDisplayUnitsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < this.table.getItemCount()) {
            TableItem item = this.table.getItem(i);
            map.put(item.getText(0), item.getText(1));
            ++i;
        }
        return map;
    }

    public void setNativeToDisplayUnitsMap(Map<String, String> newNativeToDisplayUnitsMap) {
        this.table.removeAll();
        if (newNativeToDisplayUnitsMap != null) {
            for (String key : newNativeToDisplayUnitsMap.keySet()) {
                String value = newNativeToDisplayUnitsMap.get(key);
                TableItem item = new TableItem(this.table, 0);
                item.setText(0, key);
                item.setText(1, value);
                this.validate(item, key, value);
            }
        } else {
            this.table.removeAll();
        }
    }

    private Table createTable(Composite parent) {
        final Table table = new Table((Composite)this, 2050);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] titles = new String[]{"Native Units ", "Displayed Units"};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            ++i;
        }
        i = 0;
        while (i < titles.length) {
            table.getColumn(i).pack();
            ++i;
        }
        final TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = table.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = table.getTopIndex();
                while (index < table.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = table.getItem(index);
                    int i = 0;
                    while (i < table.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)table, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            editor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.selectAll();
                            text.setFocus();
                            if (column == 0) {
                                text.addListener(2, new Listener(){

                                    public void handleEvent(Event e) {
                                        NativeToDisplayUnitsMapComposite.this.validate(item, text.getText(), item.getText(1));
                                    }
                                });
                            } else {
                                text.addListener(2, new Listener(){

                                    public void handleEvent(Event e) {
                                        NativeToDisplayUnitsMapComposite.this.validate(item, item.getText(0), text.getText());
                                    }
                                });
                            }
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
        return table;
    }

    protected void validate(TableItem item, String nativeUnitString, String displayUnitString) {
        try {
            Unit.valueOf((CharSequence)nativeUnitString);
            item.setBackground(0, null);
        }
        catch (Throwable throwable) {
            item.setBackground(0, new Color((Device)this.getDisplay(), 255, 0, 0));
        }
        try {
            Unit nativeUnit = Unit.valueOf((CharSequence)nativeUnitString);
            Unit displayUnit = Unit.valueOf((CharSequence)displayUnitString);
            if (nativeUnit.getConverterTo(displayUnit) != null) {
                item.setBackground(1, null);
            } else {
                item.setBackground(1, new Color((Device)this.getDisplay(), 255, 0, 0));
            }
        }
        catch (Throwable throwable) {
            item.setBackground(1, new Color((Device)this.getDisplay(), 255, 0, 0));
        }
    }
}

