/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.parts;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.apogy.common.e4.ApogyCommonE4Facade;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractPart<RootEObject extends EObject> {
    private Composite containerComposite;
    @Inject
    public UISynchronize uiSynchronize;
    @Inject
    public EPartService ePartService;

    public final UISynchronize getUISynchronize() {
        return this.uiSynchronize;
    }

    @PostConstruct
    private void createPartControl(Composite parent) {
        this.containerComposite = new Composite(parent, 0);
        this.containerComposite.setLayout((Layout)new FillLayout());
        this.createNoContentComposite(this.containerComposite, 0);
    }

    public Object getCurrentSelection() {
        return null;
    }

    public final Object getParentSelection(String parentPartId) {
        Object parentPartObject;
        Object result = null;
        MPart parentPart = ApogyCommonE4Facade.INSTANCE.getMPart(this.ePartService, parentPartId);
        if (parentPart != null && (parentPartObject = parentPart.getObject()) != null && parentPartObject instanceof AbstractPart) {
            result = ((AbstractPart)parentPartObject).getCurrentSelection();
        }
        return result;
    }

    protected abstract void createComposite(Composite var1, int var2);

    protected abstract void doSetContent(RootEObject var1);

    protected final void setContent(RootEObject rootEObject) {
        if (this.containerComposite != null && !this.containerComposite.isDisposed()) {
            Control[] controlArray = this.containerComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            if (rootEObject == null) {
                this.createNoContentComposite(this.containerComposite, 0);
            } else {
                this.createComposite(this.containerComposite, 0);
                this.doSetContent(rootEObject);
            }
            this.containerComposite.layout();
        }
    }

    protected void createNoContentComposite(Composite parent, int style) {
        new NoContentComposite(parent, style){

            protected String getMessage() {
                return AbstractPart.this.getNoContentMessage();
            }
        };
    }

    protected String getNoContentMessage() {
        return "No compatible selection";
    }
}

