/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui;

import java.util.HashMap;
import java.util.Map;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    private static final Logger Logger = LoggerFactory.getLogger(Activator.class);
    private Map<Ranges, RGB> rangesToRGBColorMap;
    private Map<String, String> nativeToDisplayUnitsMap;
    private IPropertyChangeListener preferencesListener = null;
    public static final String ID = "org.eclipse.apogy.common.emf.ui";
    private static BundleContext bundleContext;
    private static Activator instance;

    public static Activator getDefault() {
        return instance;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        bundleContext = context;
        instance = this;
        this.getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
    }

    public void stop(BundleContext context) throws Exception {
        this.getPreferenceStore().removePropertyChangeListener(this.getPreferencesListener());
        instance = null;
        bundleContext = null;
        super.stop(context);
    }

    public Color getRangeColor(Ranges range, Device device) {
        RGB rgb = this.getRangeToRBGMap().get(range);
        if (rgb != null) {
            return new Color(device, rgb.red, rgb.green, rgb.blue);
        }
        Display display = Display.getDefault();
        return display.getSystemColor(37);
    }

    public RGB getRangeColor(Ranges range) {
        return this.getRangeToRBGMap().get(range);
    }

    public Unit<?> getDisplayUnit(ETypedElement eTypedElement) {
        Unit<?> displayUnits = this.getETypedElementSpecificUnit(eTypedElement);
        if (displayUnits == null) {
            Unit nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(eTypedElement);
            if (nativeUnits != null) {
                displayUnits = this.getDefaultDisplayUnits(nativeUnits);
            } else {
                return null;
            }
        }
        return displayUnits;
    }

    public Unit<?> getDefaultDisplayUnits(Unit<?> nativeUnit) {
        Unit displayUnits = null;
        String displayUnitAsString = this.getNativeToDisplayUnitsMap().get(nativeUnit.toString());
        try {
            displayUnits = Unit.valueOf((CharSequence)displayUnitAsString);
        }
        catch (Throwable throwable) {}
        return displayUnits;
    }

    public Unit<?> getETypedElementSpecificUnit(ETypedElement eTypedElement) {
        return null;
    }

    private Map<Ranges, RGB> getRangeToRBGMap() {
        if (this.rangesToRGBColorMap == null) {
            this.rangesToRGBColorMap = new HashMap<Ranges, RGB>();
            this.initializeRangeToRBGMap(this.rangesToRGBColorMap);
        }
        return this.rangesToRGBColorMap;
    }

    private void initializeRangeToRBGMap(Map<Ranges, RGB> map) {
        map.clear();
        for (Ranges range : Ranges.VALUES) {
            RGB rgb = this.getRGBFromPreference(range);
            if (rgb == null) continue;
            map.put(range, rgb);
        }
    }

    private RGB getRGBFromPreference(Ranges range) {
        String value = this.getPreferenceStore().getString(range.getName());
        if ("".equals(value)) {
            return null;
        }
        return StringConverter.asRGB((String)value, null);
    }

    public Map<String, String> getNativeToDisplayUnitsMap() {
        if (this.nativeToDisplayUnitsMap == null) {
            this.nativeToDisplayUnitsMap = new HashMap<String, String>();
            this.initializeNativeToDisplayUnitsMap(this.nativeToDisplayUnitsMap);
        }
        return this.nativeToDisplayUnitsMap;
    }

    private void initializeNativeToDisplayUnitsMap(Map<String, String> map) {
        this.nativeToDisplayUnitsMap.clear();
        String mapAsString = this.getPreferenceStore().getString("NATIVE_TO_DISPLAY_UNITS_ID");
        mapAsString = mapAsString.replace("{", "");
        mapAsString = mapAsString.replace("}", "");
        String[] entries = mapAsString.split(",");
        int i = 0;
        while (i < entries.length) {
            try {
                String entry = entries[i];
                entry.trim();
                String[] keyValue = entry.split("=");
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                map.put(key, value);
            }
            catch (Exception exception) {
                Logger.warn("Failed to parse string <" + entries[i] + "> as a Native To Display Units entry!");
            }
            ++i;
        }
    }

    private IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    Activator.this.getRangeToRBGMap().clear();
                    Activator.this.initializeRangeToRBGMap(Activator.this.getRangeToRBGMap());
                    Activator.this.getNativeToDisplayUnitsMap().clear();
                    Activator.this.initializeNativeToDisplayUnitsMap(Activator.this.getNativeToDisplayUnitsMap());
                }
            };
        }
        return this.preferencesListener;
    }
}

