/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.renderers;

import javax.inject.Inject;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFactory;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.composites.GeographicCoordinatesComposite;
import org.eclipse.core.databinding.Binding;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeographicCoordinatesRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(GeographicCoordinatesRenderer.class);
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());

    @Inject
    public GeographicCoordinatesRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        return new Binding[0];
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        GeographicCoordinates coords = (GeographicCoordinates)this.getValue();
        if (coords == null) {
            coords = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createGeographicCoordinates();
            this.getModelValue().setValue((Object)coords);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        Section section = this.toolkit.createSection(composite, 320);
        this.toolkit.adapt((Composite)section);
        section.setLayout((Layout)new FillLayout());
        section.setText("Geographical Coordinates");
        GeographicCoordinatesComposite geographicCoordinatesComposite = new GeographicCoordinatesComposite((Composite)section, 0, true);
        geographicCoordinatesComposite.setGeographicCoordinates(coords);
        geographicCoordinatesComposite.setBackground(geographicCoordinatesComposite.getDisplay().getSystemColor(1));
        section.setClient((Control)geographicCoordinatesComposite);
        return composite;
    }

    protected String getUnsetText() {
        return "Unset";
    }

    protected Object getValue() {
        try {
            Object obj = this.getModelValue().getValue();
            return obj;
        }
        catch (DatabindingFailedException e) {
            Logger.error("Failed to get value.", (Throwable)e);
            return null;
        }
    }

    protected void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }
}

