/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.parts;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.apogy.common.topology.AbstractViewPoint;
import org.eclipse.apogy.core.environment.earth.ui.EarthUIFacade;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfigurationList;
import org.eclipse.e4.ui.di.AboutToHide;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class EarthViewConfigurationDynamicMenuContributions {
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        EarthViewConfigurationList cameraViewConfigurationList = EarthUIFacade.INSTANCE.getActiveEarthViewConfigurationList();
        if (cameraViewConfigurationList != null) {
            this.populate(items);
        }
    }

    @AboutToHide
    public void aboutToHide(List<MMenuElement> items) {
    }

    protected void populate(List<MMenuElement> items) {
        for (MMenuElement child : items) {
            child.setToBeRendered(false);
            child.setVisible(false);
        }
        items.clear();
        EarthViewConfigurationList cameraViewConfigurationList = EarthUIFacade.INSTANCE.getActiveEarthViewConfigurationList();
        for (EarthViewConfiguration earthViewConfiguration : cameraViewConfigurationList.getEarthViewConfigurations()) {
            MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
            dynamicItem.setLabel("Configuration - " + earthViewConfiguration.getName());
            dynamicItem.setContributionURI("bundleclass://org.eclipse.apogy.core.environment.earth.ui/org.eclipse.apogy.core.environment.earth.ui.handlers.SetActiveEarthViewConfigurationHandler");
            dynamicItem.setContributorURI("platform:/plugin/org.eclipse.apogy.core.environment.earth.ui");
            dynamicItem.setToBeRendered(true);
            dynamicItem.getTransientData().put("earthViewConfiguration", earthViewConfiguration);
            items.add((MMenuElement)dynamicItem);
        }
    }

    protected String getIconURIForAbstractViewPoint(AbstractViewPoint abstractViewPoint) {
        String uri = null;
        return uri;
    }
}

