/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.ogc.kml.impl.KMLController;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.WWIO;
import java.net.URL;
import org.eclipse.apogy.core.environment.earth.ui.impl.KMLWorldWindLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMLWorldWindLayerCustomImpl
extends KMLWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(KMLWorldWindLayerImpl.class);
    private boolean loading = false;
    private KMLController kmlController = null;

    @Override
    public void setUrl(String newUrl) {
        super.setUrl(newUrl);
        this.loadFile();
    }

    @Override
    public void initialise() {
        this.loadFile();
        super.initialise();
    }

    @Override
    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible() && this.kmlController != null) {
            try {
                layer.addRenderable((Renderable)this.kmlController);
            }
            catch (Exception e) {
                Logger.error("Error occured during updateRenderableLayer().", (Throwable)e);
            }
        }
    }

    private void loadFile() {
        if (!this.loading) {
            this.loading = true;
            this.getRenderableLayer().removeAllRenderables();
            String kmlSource = this.getUrl();
            final URL url = WWIO.makeURL((String)kmlSource);
            if (url != null) {
                Job job = new Job("Loading KML <" + url + ">"){

                    protected IStatus run(IProgressMonitor arg0) {
                        try {
                            Logger.info("Loading KML from <" + url.toString() + ">.");
                            KMLWorldWindLayerCustomImpl.this.kmlController = null;
                            KMLRoot kmlRoot = KMLRoot.createAndParse((Object)url);
                            KMLWorldWindLayerCustomImpl.this.kmlController = new KMLController(kmlRoot);
                            Logger.info("KML Loaded.");
                            RenderableLayer layer = KMLWorldWindLayerCustomImpl.this.getRenderableLayer();
                            layer.removeAllRenderables();
                            layer.addRenderable((Renderable)KMLWorldWindLayerCustomImpl.this.kmlController);
                            KMLWorldWindLayerCustomImpl.this.getRenderableLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this);
                        }
                        catch (Exception e) {
                            Logger.error("Failed to load KML from <" + url.toString() + ">.", (Throwable)e);
                        }
                        KMLWorldWindLayerCustomImpl.this.loading = false;
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }
}

