/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.impl.GeographicCoordinatesPathWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.MultiEObjectsAdapter;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeographicCoordinatesPathWorldWindLayerCustomImpl
extends GeographicCoordinatesPathWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(GeographicCoordinatesPathWorldWindLayerImpl.class);
    private MultiEObjectsAdapter geographicCoordinatesAdapter = null;
    public static final int GROUND_TRACE_STIPPLE_FACTOR = 0;
    public static final short GROUND_TRACE_STIPPLE_PATTERN = 255;

    protected GeographicCoordinatesPathWorldWindLayerCustomImpl() {
        this.eAdapters().add((Object)this.getGeographicCoordinatesAdapter());
    }

    @Override
    public void clearPath() {
        if (!this.getGeographicCoordinatesList().isEmpty()) {
            ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.GEOGRAPHIC_COORDINATES_PATH_WORLD_WIND_LAYER__GEOGRAPHIC_COORDINATES_LIST);
        }
    }

    @Override
    public void dispose() {
        this.eAdapters().remove((Object)this.getGeographicCoordinatesAdapter());
        super.dispose();
    }

    @Override
    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible()) {
            try {
                this.addRenderable(layer);
            }
            catch (Exception e) {
                Logger.error("Error occured during updateRenderableLayer().", (Throwable)e);
            }
        }
    }

    protected void addRenderable(RenderableLayer layer) {
        try {
            if (!this.getGeographicCoordinatesList().isEmpty()) {
                List<Polyline> polyLines = WorldWindUtils.createPolyLineFromGeographicCoordinatesListNoWrapAround(this.getGeographicCoordinatesList());
                for (Polyline polyLine : polyLines) {
                    polyLine.setFollowTerrain(false);
                    polyLine.setColor(Color.GREEN);
                    polyLine.setStippleFactor(0);
                    polyLine.setStipplePattern((short)255);
                    layer.addRenderable((Renderable)polyLine);
                }
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    protected MultiEObjectsAdapter getGeographicCoordinatesAdapter() {
        if (this.geographicCoordinatesAdapter == null) {
            this.geographicCoordinatesAdapter = new MultiEObjectsAdapter(){

                @Override
                public void registerToEObject(EObject eObject) {
                    if (eObject instanceof GeographicCoordinates) {
                        GeographicCoordinates newGeographicCoordinates = (GeographicCoordinates)eObject;
                        newGeographicCoordinates.eAdapters().add((Object)GeographicCoordinatesPathWorldWindLayerCustomImpl.this.getGeographicCoordinatesAdapter());
                    } else {
                        super.registerToEObject(eObject);
                    }
                }

                public void notifyChanged(Notification msg) {
                    block16: {
                        block17: {
                            if (GeographicCoordinatesPathWorldWindLayerCustomImpl.this.isDisposed()) break block16;
                            if (!(msg.getNotifier() instanceof GeographicCoordinates)) break block17;
                            int featureId = msg.getFeatureID(GeographicCoordinates.class);
                            switch (featureId) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    if (GeographicCoordinatesPathWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                        GeographicCoordinatesPathWorldWindLayerCustomImpl.this.updateRenderableLayer();
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block16;
                        }
                        if (msg.getNotifier() instanceof GeographicCoordinatesPathWorldWindLayerCustomImpl) {
                            int featureId = msg.getFeatureID(GeographicCoordinatesPathWorldWindLayerCustomImpl.class);
                            switch (featureId) {
                                case 10: {
                                    switch (msg.getEventType()) {
                                        case 3: {
                                            GeographicCoordinates coord = (GeographicCoordinates)msg.getNewValue();
                                            coord.eAdapters().add((Object)GeographicCoordinatesPathWorldWindLayerCustomImpl.this.getGeographicCoordinatesAdapter());
                                            break;
                                        }
                                        case 5: {
                                            Collection coords = (Collection)msg.getNewValue();
                                            for (GeographicCoordinates coord : coords) {
                                                coord.eAdapters().add((Object)GeographicCoordinatesPathWorldWindLayerCustomImpl.this.getGeographicCoordinatesAdapter());
                                            }
                                            break;
                                        }
                                        case 4: {
                                            GeographicCoordinates coord = (GeographicCoordinates)msg.getOldValue();
                                            coord.eAdapters().remove((Object)GeographicCoordinatesPathWorldWindLayerCustomImpl.this.getGeographicCoordinatesAdapter());
                                            break;
                                        }
                                        case 6: {
                                            Collection coords = (Collection)msg.getOldValue();
                                            for (GeographicCoordinates coord : coords) {
                                                coord.eAdapters().remove((Object)GeographicCoordinatesPathWorldWindLayerCustomImpl.this.getGeographicCoordinatesAdapter());
                                            }
                                            break;
                                        }
                                    }
                                    if (!GeographicCoordinatesPathWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) break;
                                    GeographicCoordinatesPathWorldWindLayerCustomImpl.this.updateRenderableLayer();
                                    break;
                                }
                            }
                        }
                    }
                }
            };
        }
        return this.geographicCoordinatesAdapter;
    }
}

