/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.composites;

import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.environment.earth.ui.AbstractEarthViewPoint;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class AbstractEarthViewPointListComposite<RootEObject extends EarthViewConfiguration, ResolvedEObject extends EarthViewConfiguration, ItemObject extends AbstractEarthViewPoint>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemObject> {
    public static final int NAME_COL_MIN_WIDTH = 120;
    public static final int DESCRIPTION_COL_MIN_WIDTH = 300;
    private AbstractEarthViewPoint currentViewPoint;

    public AbstractEarthViewPointListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createColumns(TreeViewer viewer) {
        final TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof AbstractEarthViewPoint) {
                    AbstractEarthViewPoint viewPoint = (AbstractEarthViewPoint)element;
                    String text = viewPoint.getName();
                    return text == null || text.length() == 0 ? "" : text;
                }
                return "";
            }
        });
        nameColumn.getColumn().setWidth(120);
        nameColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (nameColumn.getColumn().getWidth() < 120) {
                    nameColumn.getColumn().setWidth(120);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        final TreeViewerColumn descriptionColumn = new TreeViewerColumn(viewer, 0);
        descriptionColumn.getColumn().setText("Description");
        descriptionColumn.getColumn().setAlignment(0x1000000);
        descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof AbstractEarthViewPoint) {
                    AbstractEarthViewPoint viewPoint = (AbstractEarthViewPoint)element;
                    String text = viewPoint.getDescription();
                    return text == null || text.length() == 0 ? "" : text;
                }
                return "";
            }
        });
        descriptionColumn.getColumn().setWidth(300);
        descriptionColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (descriptionColumn.getColumn().getWidth() < 300) {
                    descriptionColumn.getColumn().setWidth(300);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createActivateButton(parent, style);
    }

    protected void createDeleteButtonBindings(Button button) {
        IViewerObservableValue observeSingleSelectionEListCompositetreeViewer = ViewerProperties.singleSelection().observe((Viewer)this.getViewer());
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)button);
        this.getDataBindingContext().bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionEListCompositetreeViewer, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), UpdateValueStrategy.create((IConverter)IConverter.create(Object.class, Boolean.class, o -> {
            if (o != this.currentViewPoint) {
                return true;
            }
            return false;
        })));
    }

    protected void doActivate(List<ItemObject> list) {
        if (list != null && !list.isEmpty()) {
            AbstractEarthViewPoint abstractEarthViewPoint;
            this.currentViewPoint = abstractEarthViewPoint = (AbstractEarthViewPoint)list.get(0);
            this.newViewPointActivated(abstractEarthViewPoint);
        }
    }

    protected void doNew() {
        MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
        settings.getUserDataMap().put("name", ApogyCommonEMFFacade.INSTANCE.getDefaultName(this.getRootEObject(), null, (ETypedElement)ApogyEarthEnvironmentUIPackage.Literals.EARTH_VIEW_CONFIGURATION__VIEW_POINTS));
        EObjectWizard wizard = new EObjectWizard((EObject)((EarthViewConfiguration)this.getRootEObject()), null, ApogyEarthEnvironmentUIPackage.Literals.EARTH_VIEW_CONFIGURATION__VIEW_POINTS, ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_EARTH_VIEW_POINT, (EClassSettings)settings);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected void doDelete(ItemObject object) {
        ApogyCommonTransactionFacade.INSTANCE.basicRemove(this.getRootEObject(), (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.EARTH_VIEW_CONFIGURATION__VIEW_POINTS, object, true);
    }

    protected void newViewPointActivated(AbstractEarthViewPoint abstractEarthViewPoint) {
    }
}

