/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.math.Transform;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.PositionNode;
import org.eclipse.apogy.common.topology.RotationNode;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.common.topology.ui.adapters.TransformNodeSceneObject;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransformationJME3SceneObject<T extends Node>
extends DefaultJME3SceneObject<T>
implements TransformNodeSceneObject,
Adapter {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractTransformationJME3SceneObject.class);
    private float previousAxisLength = 1.0f;
    private boolean axisVisible = true;
    private Geometry axisGeometry = null;
    private final AssetManager assetManager = this.jme3Application.getAssetManager();

    public AbstractTransformationJME3SceneObject(T topologyNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super(topologyNode, jme3RenderEngineDelegate);
        this.registerListener(topologyNode);
        this.axisGeometry = JME3Utilities.createAxis3D(1.0f, this.assetManager);
        if (this.axisVisible) {
            this.getAttachmentNode().attachChild((Spatial)this.axisGeometry);
        }
        this.requestUpdate();
    }

    @Override
    public void updateGeometry(float tpf) {
        RotationNode rotationNode;
        Matrix4d transformMatrix = new Matrix4d();
        transformMatrix.setIdentity();
        if (this.getTopologyNode() instanceof TransformNode) {
            TransformNode transformNode = (TransformNode)this.getTopologyNode();
            if (transformNode.asMatrix4d() != null) {
                transformMatrix = transformNode.asMatrix4d();
            }
        } else if (this.getTopologyNode() instanceof PositionNode) {
            PositionNode positionNode = (PositionNode)this.getTopologyNode();
            if (positionNode.getPosition() != null) {
                transformMatrix.set(new Vector3d(positionNode.getPosition().asTuple3d()));
            }
        } else if (this.getTopologyNode() instanceof RotationNode && (rotationNode = (RotationNode)this.getTopologyNode()).getRotationMatrix() != null) {
            transformMatrix.set(rotationNode.getRotationMatrix().asMatrix3d());
        }
        Transform transform = JME3Utilities.createTransform(transformMatrix);
        this.getAttachmentNode().setLocalTransform(transform);
    }

    @Override
    public void dispose() {
        if (this.getTopologyNode() != null) {
            this.unRegisterListener(this.getTopologyNode());
        }
        super.dispose();
    }

    @Override
    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (this.axisGeometry != null) {
            geometries.add(this.axisGeometry);
        }
        return geometries;
    }

    public void setAxisVisible(boolean visible) {
        Logger.info("Setting axis visible to <" + visible + ">");
        this.axisVisible = visible;
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (AbstractTransformationJME3SceneObject.this.axisVisible) {
                    AbstractTransformationJME3SceneObject.this.getAttachmentNode().attachChild((Spatial)AbstractTransformationJME3SceneObject.this.axisGeometry);
                } else {
                    AbstractTransformationJME3SceneObject.this.getAttachmentNode().detachChild((Spatial)AbstractTransformationJME3SceneObject.this.axisGeometry);
                }
                return null;
            }
        });
    }

    public void setAxisLength(final double length) {
        Logger.info("Setting axis length to <" + length + ">");
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    float scale = (float)Math.abs(length) / AbstractTransformationJME3SceneObject.this.previousAxisLength;
                    if (AbstractTransformationJME3SceneObject.this.axisGeometry != null) {
                        AbstractTransformationJME3SceneObject.this.axisGeometry.scale(scale);
                    }
                    AbstractTransformationJME3SceneObject.this.previousAxisLength = (float)length;
                }
                catch (Throwable t) {
                    Logger.error("Failed to setAxisLength(" + length + ")", t);
                }
                return null;
            }
        });
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() instanceof TransformNode) {
            int featureId = notification.getFeatureID(TransformNode.class);
            if (featureId == 6) {
                if (notification.getOldValue() instanceof Tuple3d) {
                    Tuple3d oldValue = (Tuple3d)notification.getOldValue();
                    oldValue.eAdapters().remove((Object)this);
                }
                this.requestUpdate();
                if (notification.getNewValue() instanceof Tuple3d) {
                    Tuple3d newValue = (Tuple3d)notification.getNewValue();
                    newValue.eAdapters().add((Object)this);
                }
            } else if (featureId == 7) {
                if (notification.getOldValue() instanceof Matrix3x3) {
                    Matrix3x3 oldValue = (Matrix3x3)notification.getOldValue();
                    oldValue.eAdapters().remove((Object)this);
                }
                this.requestUpdate();
                if (notification.getNewValue() instanceof Matrix3x3) {
                    Matrix3x3 newValue = (Matrix3x3)notification.getNewValue();
                    newValue.eAdapters().add((Object)this);
                }
            }
        } else if (notification.getNotifier() instanceof RotationNode) {
            int featureId = notification.getFeatureID(RotationNode.class);
            if (featureId == 6) {
                if (notification.getOldValue() instanceof Matrix3x3) {
                    Matrix3x3 oldValue = (Matrix3x3)notification.getOldValue();
                    oldValue.eAdapters().remove((Object)this);
                }
                this.requestUpdate();
                if (notification.getNewValue() instanceof Matrix3x3) {
                    Matrix3x3 newValue = (Matrix3x3)notification.getNewValue();
                    newValue.eAdapters().add((Object)this);
                }
            }
        } else if (notification.getNotifier() instanceof PositionNode) {
            int featureId = notification.getFeatureID(PositionNode.class);
            if (featureId == 6) {
                if (notification.getOldValue() instanceof Tuple3d) {
                    Tuple3d oldValue = (Tuple3d)notification.getOldValue();
                    oldValue.eAdapters().remove((Object)this);
                }
                this.requestUpdate();
                if (notification.getNewValue() instanceof Tuple3d) {
                    Tuple3d newValue = (Tuple3d)notification.getNewValue();
                    newValue.eAdapters().add((Object)this);
                }
            }
        } else if (notification.getNotifier() instanceof Tuple3d) {
            this.requestUpdate();
        } else if (notification.getNotifier() instanceof Matrix3x3) {
            this.requestUpdate();
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    protected void registerListener(T topologyNode) {
        PositionNode positionNode;
        topologyNode.eAdapters().add((Object)this);
        if (topologyNode instanceof TransformNode) {
            TransformNode transformNode = (TransformNode)topologyNode;
            if (transformNode.getRotationMatrix() != null) {
                transformNode.getRotationMatrix().eAdapters().add((Object)this);
            }
            if (transformNode.getPosition() != null) {
                transformNode.getPosition().eAdapters().add((Object)this);
            }
        } else if (topologyNode instanceof RotationNode) {
            RotationNode rotationNode = (RotationNode)topologyNode;
            if (rotationNode.getRotationMatrix() != null) {
                rotationNode.getRotationMatrix().eAdapters().add((Object)this);
            }
        } else if (topologyNode instanceof PositionNode && (positionNode = (PositionNode)topologyNode).getPosition() != null) {
            positionNode.getPosition().eAdapters().add((Object)this);
        }
    }

    protected void unRegisterListener(T topologyNode) {
        PositionNode positionNode;
        topologyNode.eAdapters().add((Object)this);
        if (topologyNode instanceof TransformNode) {
            TransformNode transformNode = (TransformNode)topologyNode;
            if (transformNode.getRotationMatrix() != null) {
                transformNode.getRotationMatrix().eAdapters().remove((Object)this);
            }
            if (transformNode.getPosition() != null) {
                transformNode.getPosition().eAdapters().remove((Object)this);
            }
        } else if (topologyNode instanceof RotationNode) {
            RotationNode rotationNode = (RotationNode)topologyNode;
            if (rotationNode.getRotationMatrix() != null) {
                rotationNode.getRotationMatrix().eAdapters().remove((Object)this);
            }
        } else if (topologyNode instanceof PositionNode && (positionNode = (PositionNode)topologyNode).getPosition() != null) {
            positionNode.getPosition().eAdapters().remove((Object)this);
        }
    }
}

