/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.ui.jme3.utils;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.JME3FovUtilities;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorsImagingJME3Utilities {
    private static final Logger Logger = LoggerFactory.getLogger(SensorsImagingJME3Utilities.class);

    public static Mesh createImageSnapshotSidesAndBack(ImageSnapshot imageSnapshot, int numberHorizontalIncrement, int numberVerticalIncrement) {
        Mesh mesh = null;
        RectangularFrustrumFieldOfView fov = imageSnapshot.getFieldOfView();
        float minRadius = (float)fov.getRange().getMinimumDistance();
        float maxRadius = (float)fov.getRange().getMaximumDistance();
        float minHorizontalAngle = (float)(fov.getHorizontalFieldOfViewAngle() / -2.0);
        float maxHorizontalAngle = (float)(fov.getHorizontalFieldOfViewAngle() / 2.0);
        float minVerticalAngle = (float)(fov.getVerticalFieldOfViewAngle() / -2.0);
        float maxVerticalAngle = (float)(fov.getVerticalFieldOfViewAngle() / 2.0);
        try {
            ArrayList verticesList = new ArrayList();
            ArrayList indexesList = new ArrayList();
            ArrayList normalslList = new ArrayList();
            JME3FovUtilities.generateHorizontalFace(verticesList, indexesList, normalslList, (float)minRadius, (float)maxRadius, (float)minVerticalAngle, (float)minHorizontalAngle, (float)maxHorizontalAngle, (int)numberHorizontalIncrement);
            JME3FovUtilities.generateHorizontalFace(verticesList, indexesList, normalslList, (float)minRadius, (float)maxRadius, (float)maxVerticalAngle, (float)minHorizontalAngle, (float)maxHorizontalAngle, (int)numberHorizontalIncrement);
            JME3FovUtilities.generateVerticalFace(verticesList, indexesList, normalslList, (float)minRadius, (float)maxRadius, (float)minHorizontalAngle, (float)minVerticalAngle, (float)maxVerticalAngle, (int)numberVerticalIncrement);
            JME3FovUtilities.generateVerticalFace(verticesList, indexesList, normalslList, (float)minRadius, (float)maxRadius, (float)maxHorizontalAngle, (float)minVerticalAngle, (float)maxVerticalAngle, (int)numberVerticalIncrement);
            JME3FovUtilities.generateEndFace(verticesList, indexesList, normalslList, (float)minRadius, (float)minHorizontalAngle, (float)maxHorizontalAngle, (float)minVerticalAngle, (float)maxVerticalAngle, (int)numberHorizontalIncrement, (int)numberVerticalIncrement, (boolean)false);
            mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
            mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(normalslList)));
            mesh.updateBound();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return mesh;
    }

    public static Mesh createImageSnapshotFrontMesh(ImageSnapshot imageSnapshot, int numberHorizontalIncrement, int numberVerticalIncrement) {
        RectangularFrustrumFieldOfView fov = imageSnapshot.getFieldOfView();
        float radius = (float)fov.getRange().getMaximumDistance();
        float minHorizontalAngle = (float)(fov.getHorizontalFieldOfViewAngle() / -2.0);
        float maxHorizontalAngle = (float)(fov.getHorizontalFieldOfViewAngle() / 2.0);
        float minVerticalAngle = (float)(fov.getVerticalFieldOfViewAngle() / -2.0);
        float maxVerticalAngle = (float)(fov.getVerticalFieldOfViewAngle() / 2.0);
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        ArrayList<Vector2f> textureCoordinatesList = new ArrayList<Vector2f>();
        double elevationAngleIncrement = (maxVerticalAngle - minVerticalAngle) / (float)(numberVerticalIncrement - 1);
        double azimuthAngleIncrement = (maxHorizontalAngle - minHorizontalAngle) / (float)(numberHorizontalIncrement - 1);
        Vector3f[][] verticesArray = new Vector3f[numberVerticalIncrement][numberHorizontalIncrement];
        double elevationAngle = minVerticalAngle;
        int elevation = 0;
        while (elevation < numberVerticalIncrement) {
            double azimuthAngle = minHorizontalAngle;
            int azimuth = 0;
            while (azimuth < numberHorizontalIncrement) {
                Vector3f vertex;
                float l = (float)((double)radius * Math.cos(elevationAngle));
                float x = (float)((double)radius * Math.sin(elevationAngle));
                float y = (float)((double)l * Math.sin(azimuthAngle));
                float z = (float)((double)l * Math.cos(azimuthAngle));
                verticesArray[elevation][azimuth] = vertex = new Vector3f(x, y, z);
                verticesList.add(vertex);
                float textureX = (float)((azimuthAngle - (double)minHorizontalAngle) / fov.getHorizontalFieldOfViewAngle());
                float textureY = (float)((elevationAngle - (double)minVerticalAngle) / fov.getVerticalFieldOfViewAngle());
                Vector2f textCoord = new Vector2f(textureX, textureY);
                textureCoordinatesList.add(textCoord);
                azimuthAngle += azimuthAngleIncrement;
                ++azimuth;
            }
            elevationAngle += elevationAngleIncrement;
            ++elevation;
        }
        elevation = 0;
        while (elevation < numberVerticalIncrement - 1) {
            int azimuth = 0;
            while (azimuth < numberHorizontalIncrement - 1) {
                Vector3f p0 = verticesArray[elevation][azimuth];
                Vector3f p1 = verticesArray[elevation][azimuth + 1];
                Vector3f p2 = verticesArray[elevation + 1][azimuth + 1];
                int index0 = verticesList.indexOf(p2);
                indexesList.add(new Integer(index0));
                int index1 = verticesList.indexOf(p1);
                indexesList.add(new Integer(index1));
                int index2 = verticesList.indexOf(p0);
                indexesList.add(new Integer(index2));
                p0 = verticesArray[elevation][azimuth];
                p1 = verticesArray[elevation + 1][azimuth + 1];
                p2 = verticesArray[elevation + 1][azimuth];
                index0 = verticesList.indexOf(p2);
                indexesList.add(new Integer(index0));
                index1 = verticesList.indexOf(p1);
                indexesList.add(new Integer(index1));
                index2 = verticesList.indexOf(p0);
                indexesList.add(new Integer(index2));
                ++azimuth;
            }
            ++elevation;
        }
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertListOfVector2fToFloatArray(textureCoordinatesList)));
        mesh.updateCounts();
        mesh.updateBound();
        return mesh;
    }
}

