/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.plugins.AWTLoader;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.sensors.fov.DistanceRange;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.RectifiedImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.ui.ImageSnapshotSceneObject;
import org.eclipse.apogy.addons.sensors.imaging.ui.jme3.utils.ImageSnapshotProjectorControl;
import org.eclipse.apogy.addons.sensors.imaging.ui.jme3.utils.SensorsImagingJME3Utilities;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSnapshotJME3Object
extends DefaultJME3SceneObject<ImageSnapshot>
implements ImageSnapshotSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(ImageSnapshotJME3Object.class);
    public static long MAXIMUM_IMAGE_SIZE = 307200L;
    public static ColorRGBA DEFAULT_IMAGE_SNAPSHOT_FOV_COLOR = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    public static float DEFAULT_ANGLE_INCREMENT = (float)Math.toRadians(10.0);
    private final double axisLenght = 1.0;
    private float previousAxisLength = 1.0f;
    private boolean axisVisible = true;
    private RGBA color = new RGBA(0, 255, 0, 255);
    private boolean imageProjectionEnabled = true;
    private boolean imageProjectionOnFOVEnabled = false;
    protected boolean fovVisible = false;
    private MeshPresentationMode meshPresentationMode = MeshPresentationMode.WIREFRAME;
    private com.jme3.scene.Node fovNode;
    private Adapter adapter;
    private AssetManager assetManager;
    private Geometry axisGeometry = null;
    private Geometry frontGeometry = null;
    private Geometry sidesAndBackGeometry = null;
    private ImageSnapshotProjectorControl imageProjector;
    private BufferedImage bufferedImage = null;

    public ImageSnapshotJME3Object(ImageSnapshot node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        if (node == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.assetManager = this.jme3Application.getAssetManager();
        this.axisGeometry = JME3Utilities.createAxis3D((float)1.0f, (AssetManager)this.assetManager);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ImageSnapshotJME3Object.this.updateGeometryInternal();
                ((ImageSnapshot)ImageSnapshotJME3Object.this.getTopologyNode()).eAdapters().add((Object)ImageSnapshotJME3Object.this.getAdapter());
                if (((ImageSnapshot)ImageSnapshotJME3Object.this.getTopologyNode()).getFieldOfView() != null) {
                    ((ImageSnapshot)ImageSnapshotJME3Object.this.getTopologyNode()).getFieldOfView().eAdapters().add((Object)ImageSnapshotJME3Object.this.getAdapter());
                    if (((ImageSnapshot)ImageSnapshotJME3Object.this.getTopologyNode()).getFieldOfView().getRange() != null) {
                        ((ImageSnapshot)ImageSnapshotJME3Object.this.getTopologyNode()).getFieldOfView().getRange().eAdapters().add((Object)ImageSnapshotJME3Object.this.getAdapter());
                    }
                }
                return null;
            }
        });
    }

    public void updateGeometry(float tpf) {
        this.updateGeometryInternal();
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((ImageSnapshot)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
            if (((ImageSnapshot)this.getTopologyNode()).getFieldOfView() != null) {
                ((ImageSnapshot)this.getTopologyNode()).getFieldOfView().eAdapters().remove((Object)this.getAdapter());
                if (((ImageSnapshot)this.getTopologyNode()).getFieldOfView().getRange() != null) {
                    ((ImageSnapshot)this.getTopologyNode()).getFieldOfView().getRange().eAdapters().remove((Object)this.getAdapter());
                }
            }
        }
        if (this.imageProjector != null) {
            this.imageProjector.dispose();
            this.imageProjector = null;
        }
        super.dispose();
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.sidesAndBackGeometry);
        geometries.add(this.frontGeometry);
        return geometries;
    }

    public void setColor(final RGBA rgb) {
        Logger.info("Setting color to <" + rgb + ">.");
        this.color = rgb;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Material mat;
                    if (ImageSnapshotJME3Object.this.frontGeometry != null) {
                        mat = ImageSnapshotJME3Object.this.createMaterial();
                        mat.setColor("Diffuse", JME3Utilities.convertToColorRGBA((RGBA)rgb));
                        mat.setColor("Ambient", JME3Utilities.convertToColorRGBA((RGBA)rgb));
                        mat.setColor("Specular", JME3Utilities.convertToColorRGBA((RGBA)rgb));
                        ImageSnapshotJME3Object.this.frontGeometry.setMaterial(mat);
                    }
                    if (ImageSnapshotJME3Object.this.sidesAndBackGeometry != null) {
                        mat = ImageSnapshotJME3Object.this.createMaterial();
                        mat.setColor("Diffuse", JME3Utilities.convertToColorRGBA((RGBA)rgb));
                        mat.setColor("Ambient", JME3Utilities.convertToColorRGBA((RGBA)rgb));
                        mat.setColor("Specular", JME3Utilities.convertToColorRGBA((RGBA)rgb));
                        ImageSnapshotJME3Object.this.sidesAndBackGeometry.setMaterial(mat);
                    }
                }
                catch (Throwable t) {
                    Logger.error("Failed to set color to <" + rgb + ">.", t);
                }
                return null;
            }
        });
    }

    public RGBA getColor() {
        return this.color;
    }

    public MeshPresentationMode getPresentationMode() {
        return this.meshPresentationMode;
    }

    public void setPresentationMode(final MeshPresentationMode mode) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ImageSnapshotJME3Object.this.internalSetPresentationMode(mode);
                return null;
            }
        });
    }

    public boolean isImageProjectionEnabled() {
        return this.imageProjectionEnabled;
    }

    public boolean isImageProjectionOnFOVEnabled() {
        return this.imageProjectionOnFOVEnabled;
    }

    public void setImageProjectionOnFOVEnabled(boolean enabled) {
        Logger.info("Setting Projection on FOV enabled to <" + enabled + ">.");
        this.imageProjectionOnFOVEnabled = enabled;
        this.requestUpdate();
    }

    public void setImageProjectionEnabled(final boolean enabled) {
        Logger.info("Setting Projection enabled to <" + enabled + ">.");
        this.imageProjectionEnabled = enabled;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ImageSnapshotJME3Object.this.getImageProjector().setEnabled(enabled);
                return null;
            }
        });
    }

    public void setFOVVisible(boolean visible) {
        Logger.info("Setting FOV visibility to <" + visible + ">.");
        this.fovVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (!ImageSnapshotJME3Object.this.fovVisible && ImageSnapshotJME3Object.this.getAttachmentNode().hasChild((Spatial)ImageSnapshotJME3Object.this.getFovNode())) {
                    ImageSnapshotJME3Object.this.getAttachmentNode().detachChild((Spatial)ImageSnapshotJME3Object.this.getFovNode());
                } else if (ImageSnapshotJME3Object.this.fovVisible && !ImageSnapshotJME3Object.this.getAttachmentNode().hasChild((Spatial)ImageSnapshotJME3Object.this.getFovNode())) {
                    ImageSnapshotJME3Object.this.getAttachmentNode().attachChild((Spatial)ImageSnapshotJME3Object.this.getFovNode());
                }
                return null;
            }
        });
    }

    public boolean isFOVVisible() {
        return this.fovVisible;
    }

    public boolean isAxisVisible() {
        return this.axisVisible;
    }

    public void setAxisVisible(boolean visible) {
        Logger.info("Setting axis visible to <" + visible + ">.");
        this.axisVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ImageSnapshotJME3Object.this.axisVisible && !ImageSnapshotJME3Object.this.getAttachmentNode().hasChild((Spatial)ImageSnapshotJME3Object.this.axisGeometry)) {
                    ImageSnapshotJME3Object.this.getAttachmentNode().attachChild((Spatial)ImageSnapshotJME3Object.this.axisGeometry);
                } else if (ImageSnapshotJME3Object.this.getAttachmentNode().hasChild((Spatial)ImageSnapshotJME3Object.this.axisGeometry)) {
                    ImageSnapshotJME3Object.this.getAttachmentNode().detachChild((Spatial)ImageSnapshotJME3Object.this.axisGeometry);
                }
                return null;
            }
        });
    }

    public double getAxisLength() {
        return 1.0;
    }

    public void setAxisLength(final double length) {
        if (length > 0.0) {
            Logger.info("Setting axis length to <" + length + ">.");
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        float scale = (float)Math.abs(length) / ImageSnapshotJME3Object.this.previousAxisLength;
                        if (ImageSnapshotJME3Object.this.axisGeometry != null) {
                            ImageSnapshotJME3Object.this.axisGeometry.scale(scale);
                        }
                        ImageSnapshotJME3Object.this.previousAxisLength = (float)length;
                    }
                    catch (Throwable t) {
                        Logger.error("Failed to setAxisLength(" + length + ").", t);
                    }
                    return null;
                }
            });
        } else {
            Logger.error("Setting axis length to <" + length + ">  failed : Length must be greater than zero.");
        }
    }

    protected com.jme3.scene.Node getFovNode() {
        if (this.fovNode == null) {
            String name = null;
            name = this.getTopologyNode() != null && ((ImageSnapshot)this.getTopologyNode()).getNodeId() != null ? ((ImageSnapshot)this.getTopologyNode()).getNodeId() : ((Object)((Object)this)).getClass().getSimpleName();
            name = String.valueOf(name) + "_fov";
            this.fovNode = new com.jme3.scene.Node(name);
            this.getAttachmentNode().attachChild((Spatial)this.fovNode);
        }
        return this.fovNode;
    }

    private void internalSetPresentationMode(MeshPresentationMode mode) {
        switch (mode.getValue()) {
            case 1: {
                Mesh mesh;
                if (this.frontGeometry != null && this.frontGeometry.getMaterial() != null) {
                    mesh = this.frontGeometry.getMesh();
                    this.frontGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    if (mesh != null) {
                        mesh.setMode(Mesh.Mode.Triangles);
                    }
                }
                if (this.sidesAndBackGeometry == null || this.sidesAndBackGeometry.getMaterial() == null) break;
                mesh = this.sidesAndBackGeometry.getMesh();
                this.sidesAndBackGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                if (mesh == null) break;
                mesh.setMode(Mesh.Mode.Triangles);
                break;
            }
            case 2: {
                Mesh mesh;
                if (this.frontGeometry != null && this.frontGeometry.getMaterial() != null) {
                    mesh = this.frontGeometry.getMesh();
                    this.frontGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                    if (mesh != null) {
                        mesh.setMode(Mesh.Mode.Lines);
                    }
                }
                if (this.sidesAndBackGeometry == null || this.sidesAndBackGeometry.getMaterial() == null) break;
                mesh = this.sidesAndBackGeometry.getMesh();
                this.sidesAndBackGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                if (mesh == null) break;
                mesh.setMode(Mesh.Mode.Lines);
                break;
            }
            case 0: {
                Mesh mesh;
                if (this.frontGeometry != null && this.frontGeometry.getMaterial() != null) {
                    mesh = this.frontGeometry.getMesh();
                    this.frontGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    if (mesh != null) {
                        mesh.setMode(Mesh.Mode.Points);
                    }
                }
                if (this.sidesAndBackGeometry == null || this.sidesAndBackGeometry.getMaterial() == null) break;
                mesh = this.sidesAndBackGeometry.getMesh();
                this.sidesAndBackGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                if (mesh == null) break;
                mesh.setMode(Mesh.Mode.Points);
                break;
            }
        }
        this.meshPresentationMode = mode;
    }

    private void updateGeometryInternal() {
        if (this.frontGeometry != null) {
            this.getFovNode().detachChild((Spatial)this.frontGeometry);
        }
        if (this.sidesAndBackGeometry != null) {
            this.getFovNode().detachChild((Spatial)this.sidesAndBackGeometry);
        }
        if (((ImageSnapshot)this.getTopologyNode()).getFieldOfView() != null) {
            int numberHorizontalIncrement = 5;
            numberHorizontalIncrement = ((ImageSnapshot)this.getTopologyNode()).getFieldOfView().getHorizontalFieldOfViewAngle() > (double)(5.0f * DEFAULT_ANGLE_INCREMENT) ? (int)Math.round(((ImageSnapshot)this.getTopologyNode()).getFieldOfView().getHorizontalFieldOfViewAngle() / (double)DEFAULT_ANGLE_INCREMENT) : 5;
            int numberVerticalIncrement = 5;
            numberVerticalIncrement = ((ImageSnapshot)this.getTopologyNode()).getFieldOfView().getVerticalFieldOfViewAngle() > (double)(5.0f * DEFAULT_ANGLE_INCREMENT) ? (int)Math.round(((ImageSnapshot)this.getTopologyNode()).getFieldOfView().getVerticalFieldOfViewAngle() / (double)DEFAULT_ANGLE_INCREMENT) : 5;
            Mesh frontMesh = SensorsImagingJME3Utilities.createImageSnapshotFrontMesh((ImageSnapshot)this.getTopologyNode(), numberHorizontalIncrement, numberVerticalIncrement);
            Mesh sidesAndBackMesh = SensorsImagingJME3Utilities.createImageSnapshotSidesAndBack((ImageSnapshot)this.getTopologyNode(), numberHorizontalIncrement, numberVerticalIncrement);
            this.frontGeometry = new Geometry("front", frontMesh);
            if (this.imageProjectionOnFOVEnabled) {
                this.frontGeometry.setMaterial(this.createImageMaterial());
            } else {
                this.frontGeometry.setMaterial(this.createMaterial());
            }
            this.sidesAndBackGeometry = new Geometry("SidesAndBack", sidesAndBackMesh);
            this.sidesAndBackGeometry.setMaterial(this.createMaterial());
            this.getFovNode().attachChild((Spatial)this.frontGeometry);
            this.getFovNode().attachChild((Spatial)this.sidesAndBackGeometry);
            this.internalSetPresentationMode(this.meshPresentationMode);
            this.getAttachmentNode().addControl((Control)this.getImageProjector());
        }
    }

    private Material createMaterial() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.getColor() != null) {
            mat.setColor("Diffuse", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
            mat.setColor("Ambient", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
            mat.setColor("Specular", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
        } else {
            mat.setColor("Diffuse", DEFAULT_IMAGE_SNAPSHOT_FOV_COLOR.clone());
            mat.setColor("Ambient", DEFAULT_IMAGE_SNAPSHOT_FOV_COLOR.clone());
            mat.setColor("Specular", DEFAULT_IMAGE_SNAPSHOT_FOV_COLOR.clone());
        }
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.setBoolean("UseAlpha", true);
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        return mat;
    }

    private AbstractEImage getAbstractEImage() {
        AbstractEImage image = null;
        if (this.getTopologyNode() instanceof RectifiedImageSnapshot) {
            image = ((RectifiedImageSnapshot)this.getTopologyNode()).getRectifiedImage();
        }
        if (image == null) {
            image = ((ImageSnapshot)this.getTopologyNode()).getImage();
        }
        return image;
    }

    private Material createImageMaterial() {
        Material mat = null;
        AbstractEImage abstractEImage = this.getAbstractEImage();
        if (abstractEImage != null) {
            if (this.bufferedImage == null) {
                AbstractEImage rescaledImage = this.resizeAbstractEImage(abstractEImage);
                this.bufferedImage = rescaledImage.asBufferedImage();
            }
            AWTLoader awtLoader = new AWTLoader();
            Image img = awtLoader.load(this.bufferedImage, true);
            Texture2D texture = new Texture2D(img);
            mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            mat.setTexture("ColorMap", (Texture)texture);
        } else {
            mat = this.createMaterial();
        }
        return mat;
    }

    private AbstractEImage resizeAbstractEImage(AbstractEImage originalImage) {
        long imageSize = originalImage.getHeight() * originalImage.getWidth();
        if (imageSize > MAXIMUM_IMAGE_SIZE) {
            double scaleFactor = Math.sqrt((double)MAXIMUM_IMAGE_SIZE / (double)imageSize);
            Logger.info("Image too large <" + originalImage.getHeight() + " X " + originalImage.getWidth() + ">, resizing by factor " + scaleFactor + ".");
            AbstractEImage rescaled = EImagesUtilities.INSTANCE.resize(originalImage, scaleFactor, scaleFactor);
            return rescaled;
        }
        return originalImage;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof RectifiedImageSnapshot) {
                        int featureId = msg.getFeatureID(RectifiedImageSnapshot.class);
                        switch (featureId) {
                            case 3: {
                                ImageSnapshotJME3Object.this.bufferedImage = null;
                                ImageSnapshotJME3Object.this.requestUpdate();
                                break;
                            }
                            case 6: {
                                if (msg.getOldValue() instanceof RectangularFrustrumFieldOfView) {
                                    RectangularFrustrumFieldOfView oldValue = (RectangularFrustrumFieldOfView)msg.getOldValue();
                                    oldValue.eAdapters().remove((Object)ImageSnapshotJME3Object.this.getAdapter());
                                }
                                if (msg.getNewValue() instanceof RectangularFrustrumFieldOfView) {
                                    RectangularFrustrumFieldOfView newValue = (RectangularFrustrumFieldOfView)msg.getNewValue();
                                    newValue.eAdapters().remove((Object)ImageSnapshotJME3Object.this.getAdapter());
                                }
                                ImageSnapshotJME3Object.this.requestUpdate();
                                break;
                            }
                        }
                    } else if (msg.getNotifier() instanceof ImageSnapshot) {
                        int featureId = msg.getFeatureID(ImageSnapshot.class);
                        switch (featureId) {
                            case 7: {
                                ImageSnapshotJME3Object.this.bufferedImage = null;
                                ImageSnapshotJME3Object.this.requestUpdate();
                                break;
                            }
                            case 6: {
                                if (msg.getOldValue() instanceof RectangularFrustrumFieldOfView) {
                                    RectangularFrustrumFieldOfView oldValue = (RectangularFrustrumFieldOfView)msg.getOldValue();
                                    oldValue.eAdapters().remove((Object)ImageSnapshotJME3Object.this.getAdapter());
                                }
                                if (msg.getNewValue() instanceof RectangularFrustrumFieldOfView) {
                                    RectangularFrustrumFieldOfView newValue = (RectangularFrustrumFieldOfView)msg.getNewValue();
                                    newValue.eAdapters().remove((Object)ImageSnapshotJME3Object.this.getAdapter());
                                }
                                ImageSnapshotJME3Object.this.requestUpdate();
                                break;
                            }
                        }
                    } else if (msg.getNotifier() instanceof RectangularFrustrumFieldOfView) {
                        int featureId = msg.getFeatureID(RectangularFrustrumFieldOfView.class);
                        switch (featureId) {
                            case 4: {
                                if (msg.getOldValue() instanceof DistanceRange) {
                                    DistanceRange oldValue = (DistanceRange)msg.getOldValue();
                                    oldValue.eAdapters().remove((Object)ImageSnapshotJME3Object.this.getAdapter());
                                }
                                if (msg.getNewValue() instanceof DistanceRange) {
                                    DistanceRange newValue = (DistanceRange)msg.getNewValue();
                                    newValue.eAdapters().remove((Object)ImageSnapshotJME3Object.this.getAdapter());
                                }
                                ImageSnapshotJME3Object.this.requestUpdate();
                                break;
                            }
                            case 5: 
                            case 6: {
                                ImageSnapshotJME3Object.this.requestUpdate();
                                break;
                            }
                        }
                    } else if (msg.getNotifier() instanceof DistanceRange) {
                        ImageSnapshotJME3Object.this.requestUpdate();
                    }
                }
            };
        }
        return this.adapter;
    }

    private ImageSnapshotProjectorControl getImageProjector() {
        if (this.imageProjector == null) {
            this.imageProjector = new ImageSnapshotProjectorControl(this.jme3Application, (ImageSnapshot)this.getTopologyNode());
        }
        return this.imageProjector;
    }
}

