/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ros.ui.composites;

import java.util.List;
import org.eclipse.apogy.addons.mqtt.ApogyAddonsMQTTPackage;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSFacade;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSPackage;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorClientProfile;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServer;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServerRegistry;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServiceID;
import org.eclipse.apogy.addons.mqtt.ros.ui.wizards.DeleteServiceWizard;
import org.eclipse.apogy.addons.mqtt.ros.ui.wizards.MQTTROSArbitratorServerImportWizard;
import org.eclipse.apogy.addons.mqtt.ui.ApogyAddonsMQTTUIFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTROSArbitratorServerListComposite
extends EMFFormsEListComposite<MQTTROSArbitratorServerRegistry, MQTTROSArbitratorServerRegistry, MQTTROSArbitratorServer> {
    private static final Logger Logger = LoggerFactory.getLogger(MQTTROSArbitratorServerListComposite.class);
    public static String path = System.getProperty("user.home");
    private Adapter adapter;
    private MQTTROSArbitratorServerRegistry registry;

    public MQTTROSArbitratorServerListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER_REGISTRY__SERVER_LIST, settings);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (MQTTROSArbitratorServerListComposite.this.registry != null) {
                    MQTTROSArbitratorServerListComposite.this.registry.eAdapters().remove((Object)MQTTROSArbitratorServerListComposite.this.getAdapter());
                }
            }
        });
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return MQTTROSArbitratorServerListComposite.this.getEStructuralFeature();
            }

            public Object[] getElements(Object object) {
                if (object instanceof MQTTROSArbitratorServerRegistry) {
                    MQTTROSArbitratorServerRegistry registry = (MQTTROSArbitratorServerRegistry)object;
                    return registry.getServerList().toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object object) {
                return new Object[0];
            }
        };
    }

    protected void createButtons(Composite parent, int style) {
        this.createStartButton(parent, style);
        this.createStopButton(parent, style);
        this.createSeparator(parent, style);
        this.createNewButton(parent, style);
        this.createExportButton(parent, style);
        this.createImportButton(parent, style);
        this.createSeparator(parent, style);
        this.createAddServiceButton(parent, style);
        this.createDeleteServiceButton(parent, style);
    }

    protected void doStart(List<MQTTROSArbitratorServer> list) {
        for (MQTTROSArbitratorServer server : list) {
            try {
                server.start();
            }
            catch (Exception e) {
                Logger.error("\"Start Server Failed!", (Throwable)e);
                String message = "Start Server Failed : " + e.getMessage();
                MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Start server failed!", null, message, 1, new String[]{"OK"}, 0);
                dialog.open();
            }
        }
        this.refreshViewer();
    }

    protected void doStop(List<MQTTROSArbitratorServer> list) {
        for (MQTTROSArbitratorServer server : list) {
            try {
                server.stop();
            }
            catch (Exception e) {
                Logger.error("\"Stop Server Failed!", (Throwable)e);
                String message = "Stop Server Failed : " + e.getMessage();
                MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Stop server failed", null, message, 1, new String[]{"OK"}, 0);
                dialog.open();
            }
        }
        this.refreshViewer();
    }

    protected void doNew() {
        new WizardDialog(this.getShell(), (IWizard)new EObjectWizard(this.getRootEObject(), this.getFeaturePath(), (EReference)this.getEStructuralFeature(), ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER, null)).open();
    }

    protected void doExport() {
        for (MQTTROSArbitratorServer server : this.getSelectedItemObjects()) {
            FileDialog fd = new FileDialog(this.getShell(), 8192);
            fd.setText("Export MQTTROSArbitratorServer <" + server.getName() + ">.");
            fd.setFilterPath(path);
            fd.setFilterExtensions(new String[]{"*.arbitrator"});
            if (server.getName() != null) {
                fd.setFileName(String.valueOf(server.getName()) + ".arbitrator");
            } else {
                fd.setFileName("unamed.arbitrator");
            }
            fd.setOverwrite(true);
            String filePath = fd.open();
            if (filePath == null) continue;
            try {
                ApogyAddonsMQTTROSFacade.INSTANCE.saveToFile(server, filePath);
            }
            catch (Exception ex) {
                Logger.error("Failed to export Feature of Interests from file<" + filePath + ">.", (Throwable)ex);
            }
        }
    }

    protected void createImportButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> true);
    }

    protected void doImport() {
        MQTTROSArbitratorServerImportWizard wizard = new MQTTROSArbitratorServerImportWizard();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        this.refreshViewer();
    }

    protected Button createAddServiceButton(Composite parent, int style) {
        Button btn = MQTTROSArbitratorServerListComposite.createButton((Composite)parent, (int)0, (String)"Add Service", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> this.doAddService()));
        this.createAddServiceButtonBindings(btn);
        return btn;
    }

    protected void createAddServiceButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doAddService() {
        MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)this.getSelectedItemObjects().get(0);
        EObjectWizard wizard = new EObjectWizard((EObject)server, null, ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__SERVICES, ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVICE_ID, null);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        if (wizard.getCreatedEObject() instanceof MQTTROSArbitratorServiceID) {
            MQTTROSArbitratorServiceID service = (MQTTROSArbitratorServiceID)wizard.getCreatedEObject();
            Logger.info("Added Service <" + service.getServiceName() + ">");
        }
        this.refreshViewer();
    }

    protected Button createDeleteServiceButton(Composite parent, int style) {
        Button btn = MQTTROSArbitratorServerListComposite.createButton((Composite)parent, (int)0, (String)"Delete Service", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> this.doDeleteService()));
        this.createDeleteServiceButtonBindings(btn);
        return btn;
    }

    protected void createDeleteServiceButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doDeleteService() {
        MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)this.getSelectedItemObjects().get(0);
        DeleteServiceWizard wizard = new DeleteServiceWizard(server, (MQTTROSArbitratorClientProfile)server.getUsers().get(0), (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__SERVICES, null);
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.open();
        this.refreshViewer();
    }

    public void setRootEObject(MQTTROSArbitratorServerRegistry rootEObject) {
        super.setRootEObject((EObject)rootEObject);
        if (this.registry != null) {
            this.registry.eAdapters().remove((Object)this.getAdapter());
        }
        if (rootEObject != null) {
            rootEObject.eAdapters().add((Object)this.getAdapter());
        }
        this.registry = rootEObject;
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTROSArbitratorServer) {
                    MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)element;
                    if (server.getName() == null) {
                        return "<unamed>";
                    }
                    return server.getName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)300);
        TreeViewerColumn clientSideHost = new TreeViewerColumn(viewer, 0);
        clientSideHost.getColumn().setText("Clients Host");
        clientSideHost.getColumn().setAlignment(0x1000000);
        clientSideHost.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTROSArbitratorServer) {
                    MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)element;
                    if (server.getClientSide() != null) {
                        return server.getClientSide().getBrokerHostName();
                    }
                    return "null";
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                String toolTip = "Name of MQTT broker on which the server is listening for clients requests and writing responses to clients.";
                toolTip = String.valueOf(toolTip) + "(" + this.getText(element) + ")";
                return toolTip;
            }
        });
        clientSideHost.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn clientSidePort = new TreeViewerColumn(viewer, 0);
        clientSidePort.getColumn().setText("Clients Port");
        clientSidePort.getColumn().setAlignment(0x1000000);
        clientSidePort.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTROSArbitratorServer) {
                    MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)element;
                    if (server.getClientSide() != null) {
                        return Integer.toString(server.getClientSide().getPort());
                    }
                    return "null";
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                return "Host port of the Broker on which the server is listening for clients requests and writing responses to clients.";
            }
        });
        clientSidePort.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)50);
        TreeViewerColumn clientSideState = new TreeViewerColumn(viewer, 0);
        clientSideState.getColumn().setText("Clients State");
        clientSideState.getColumn().setAlignment(0x1000000);
        clientSideState.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTROSArbitratorServer) {
                    MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)element;
                    if (server.getClientSide() != null) {
                        return server.getClientSide().getState().getLiteral();
                    }
                    return "null";
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__STATE);
            }

            public Color getBackground(Object element) {
                MQTTROSArbitratorServer server;
                if (element instanceof MQTTROSArbitratorServer && (server = (MQTTROSArbitratorServer)element).getClientSide() != null) {
                    return ApogyAddonsMQTTUIFacade.INSTANCE.getColor(server.getClientSide().getState());
                }
                return super.getBackground(element);
            }
        });
        clientSideState.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn rosSideHost = new TreeViewerColumn(viewer, 0);
        rosSideHost.getColumn().setText("ROS Host");
        rosSideHost.getColumn().setAlignment(0x1000000);
        rosSideHost.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTROSArbitratorServer) {
                    MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)element;
                    if (server.getRosSide() != null) {
                        return server.getRosSide().getBrokerHostName();
                    }
                    return "null";
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                String toolTip = "Name of MQTT broker which the server is writing ROS Requests and listening for ROS Responses.";
                toolTip = String.valueOf(toolTip) + "(" + this.getText(element) + ")";
                return toolTip;
            }
        });
        rosSideHost.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn rosSidePort = new TreeViewerColumn(viewer, 0);
        rosSidePort.getColumn().setText("ROS Port");
        rosSidePort.getColumn().setAlignment(0x1000000);
        rosSidePort.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTROSArbitratorServer) {
                    MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)element;
                    if (server.getRosSide() != null) {
                        return Integer.toString(server.getRosSide().getPort());
                    }
                    return "null";
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                return "Host port of the Broker on which the server is writing ROS Requests and listening for ROS Responses.";
            }
        });
        rosSidePort.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)50);
        TreeViewerColumn rosSideState = new TreeViewerColumn(viewer, 0);
        rosSideState.getColumn().setText("ROS State");
        rosSideState.getColumn().setAlignment(0x1000000);
        rosSideState.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTROSArbitratorServer) {
                    MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)element;
                    if (server.getRosSide() != null) {
                        return server.getRosSide().getState().getLiteral();
                    }
                    return "null";
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__STATE);
            }

            public Color getBackground(Object element) {
                MQTTROSArbitratorServer server;
                if (element instanceof MQTTROSArbitratorServer && (server = (MQTTROSArbitratorServer)element).getRosSide() != null) {
                    return ApogyAddonsMQTTUIFacade.INSTANCE.getColor(server.getRosSide().getState());
                }
                return super.getBackground(element);
            }
        });
        rosSideState.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(final Notification msg) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!MQTTROSArbitratorServerListComposite.this.isDisposed() && MQTTROSArbitratorServerListComposite.this.getViewer() != null) {
                                MQTTROSArbitratorServerListComposite.this.getViewer().refresh(msg.getNotifier(), true);
                            }
                        }
                    });
                }
            };
        }
        return this.adapter;
    }
}

