/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;

public final class Color
extends Resource {
    public GdkColor handle;
    public GdkRGBA handleRGBA;
    int alpha = 0;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int red, int green, int blue) {
        super(device);
        this.init(red, green, blue, 255);
        this.init();
    }

    public Color(Device device, int red, int green, int blue, int alpha) {
        super(device);
        this.init(red, green, blue, alpha);
        this.init();
    }

    public Color(Device device, RGB rgb) {
        super(device);
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue, 255);
        this.init();
    }

    public Color(Device device, RGBA rgba) {
        super(device);
        if (rgba == null) {
            SWT.error(4);
        }
        this.init(rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, rgba.alpha);
        this.init();
    }

    public Color(Device device, RGB rgb, int alpha) {
        super(device);
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(rgb.red, rgb.green, rgb.blue, alpha);
        this.init();
    }

    @Override
    void destroy() {
        if (GTK.GTK3) {
            this.handleRGBA = null;
        } else {
            int pixel = this.handle.pixel;
            if (this.device.colorRefCount != null) {
                int n = pixel;
                this.device.colorRefCount[n] = this.device.colorRefCount[n] - 1;
                if (this.device.colorRefCount[n] == 0) {
                    this.device.gdkColors[pixel] = null;
                }
            }
            long colormap = GDK.gdk_colormap_get_system();
            GDK.gdk_colormap_free_colors(colormap, this.handle, 1);
            this.handle = null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        if (GTK.GTK3) {
            GdkRGBA gdkRGBA = color.handleRGBA;
            if (this.handleRGBA == gdkRGBA) {
                return true;
            }
            return this.device == color.device && Double.compare(this.handleRGBA.red, gdkRGBA.red) == 0 && Double.compare(this.handleRGBA.green, gdkRGBA.green) == 0 && Double.compare(this.handleRGBA.blue, gdkRGBA.blue) == 0 && Double.compare(this.handleRGBA.alpha, gdkRGBA.alpha) == 0;
        }
        GdkColor gdkColor = color.handle;
        if (this.handle == gdkColor) {
            return true;
        }
        return this.device == color.device && this.handle.red == gdkColor.red && this.handle.green == gdkColor.green && this.handle.blue == gdkColor.blue && this.alpha == color.alpha;
    }

    public int getAlpha() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.alpha;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (GTK.GTK3) {
            return (int)(this.handleRGBA.blue * 255.0) & 0xFF;
        }
        return this.handle.blue >> 8 & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (GTK.GTK3) {
            return (int)(this.handleRGBA.green * 255.0) & 0xFF;
        }
        return this.handle.green >> 8 & 0xFF;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (GTK.GTK3) {
            return (int)(this.handleRGBA.red * 255.0) & 0xFF;
        }
        return this.handle.red >> 8 & 0xFF;
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        if (GTK.GTK3) {
            return Double.hashCode(this.handleRGBA.red) ^ Double.hashCode(this.handleRGBA.green) ^ Double.hashCode(this.handleRGBA.blue) ^ Double.hashCode(this.handleRGBA.alpha);
        }
        return this.handle.red ^ this.handle.green ^ this.handle.blue ^ this.alpha;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public RGBA getRGBA() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGBA(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public static Color gtk_new(Device device, GdkColor gdkColor) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return Color.gtk_new(device, gdkColor, 255);
    }

    public static Color gtk_new(Device device, GdkRGBA gdkRGBA) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        Color color = new Color(device);
        color.handleRGBA = gdkRGBA;
        color.alpha = (int)(gdkRGBA.alpha * 255.0);
        return color;
    }

    public static Color gtk_new(Device device, GdkColor gdkColor, int alpha) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        Color color = new Color(device);
        color.handle = gdkColor;
        color.alpha = alpha;
        return color;
    }

    public static Color gtk_new(Device device, GdkRGBA gdkRGBA, int alpha) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        Color color = new Color(device);
        color.handleRGBA = gdkRGBA;
        color.alpha = alpha;
        return color;
    }

    void init(int red, int green, int blue, int alpha) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0 || alpha > 255 || alpha < 0) {
            SWT.error(5);
        }
        if (!GTK.GTK3) {
            GdkColor gdkColor = new GdkColor();
            gdkColor.red = (short)(red & 0xFF | (red & 0xFF) << 8);
            gdkColor.green = (short)(green & 0xFF | (green & 0xFF) << 8);
            gdkColor.blue = (short)(blue & 0xFF | (blue & 0xFF) << 8);
            this.alpha = alpha;
            long colormap = GDK.gdk_colormap_get_system();
            if (!GDK.gdk_colormap_alloc_color(colormap, gdkColor, true, true)) {
                gdkColor = new GdkColor();
                GDK.gdk_colormap_alloc_color(colormap, gdkColor, true, true);
            }
            this.handle = gdkColor;
            if (this.device.colorRefCount != null) {
                GdkColor colorCopy = new GdkColor();
                colorCopy.red = this.handle.red;
                colorCopy.green = this.handle.green;
                colorCopy.blue = this.handle.blue;
                colorCopy.pixel = this.handle.pixel;
                this.device.gdkColors[colorCopy.pixel] = colorCopy;
                int n = colorCopy.pixel;
                this.device.colorRefCount[n] = this.device.colorRefCount[n] + 1;
            }
        } else {
            GdkRGBA rgba = new GdkRGBA();
            rgba.red = (double)red / 255.0;
            rgba.green = (double)green / 255.0;
            rgba.blue = (double)blue / 255.0;
            rgba.alpha = (double)alpha / 255.0;
            this.alpha = alpha;
            this.handleRGBA = rgba;
        }
    }

    @Override
    public boolean isDisposed() {
        if (GTK.GTK3) {
            return this.handleRGBA == null;
        }
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "}";
    }
}

