/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.impl;

import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.INodeVisitor;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.impl.TransformNodeImpl;

public class TransformNodeCustomImpl
extends TransformNodeImpl {
    protected static final Tuple3d ROTATION_EDEFAULT = null;
    protected static final Matrix3d ROTATION_MATRIX_EDEFAULT = null;

    public void unsetTransformationMatrix() {
    }

    public boolean isSetTransformationMatrix() {
        return false;
    }

    @Override
    public Matrix3x3 getRotationMatrix() {
        Matrix3x3 tmp = super.getRotationMatrix();
        if (tmp == null) {
            Matrix3d matrix = new Matrix3d();
            matrix.setIdentity();
            tmp = ApogyCommonMathFacade.INSTANCE.createMatrix3x3(matrix);
            this.setRotationMatrix(tmp);
        }
        return tmp;
    }

    @Override
    public Matrix4d asMatrix4d() {
        Matrix4d result = new Matrix4d();
        result.setIdentity();
        if (this.getRotationMatrix() != null) {
            result.setRotation(this.getRotationMatrix().asMatrix3d());
        }
        if (this.getPosition() != null) {
            result.setTranslation(new Vector3d(this.getPosition().asTuple3d()));
        }
        return result;
    }

    @Override
    public void setTransformation(Matrix4d matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException();
        }
        Matrix3d rotation = new Matrix3d();
        Vector3d translation = new Vector3d();
        matrix.getRotationScale(rotation);
        matrix.get(translation);
        Matrix3x3 rMat = ApogyCommonMathFacade.INSTANCE.createMatrix3x3(rotation);
        Tuple3d trans = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)translation);
        this.setRotationMatrix(rMat);
        this.setPosition(trans);
    }

    @Override
    public void accept(INodeVisitor visitor) {
        if (visitor.getType().isInstance(this)) {
            visitor.visit(this);
        }
        for (Node child : this.getChildren()) {
            child.accept(visitor);
        }
    }
}

