/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.provider;

import java.text.DecimalFormat;
import org.eclipse.apogy.core.environment.earth.ui.AirspaceWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.SurfacePolygonWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.provider.AirspaceWorldWindLayerItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class AirspaceWorldWindLayerCustomItemProvider
extends AirspaceWorldWindLayerItemProvider {
    protected DecimalFormat format = new DecimalFormat("0");

    public AirspaceWorldWindLayerCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        String suffix;
        AirspaceWorldWindLayer airspaceWorldWindLayer = (AirspaceWorldWindLayer)object;
        String label = airspaceWorldWindLayer.getName();
        if (label == null || label.length() == 0) {
            label = this.getString("_UI_AirspaceWorldWindLayer_type");
        }
        if ((suffix = this.getAirspaceWorldWindLayerSuffix(airspaceWorldWindLayer)).length() > 0) {
            label = String.valueOf(label) + " (" + suffix + ")";
        }
        return label;
    }

    protected String getAirspaceWorldWindLayerSuffix(AirspaceWorldWindLayer airspaceWorldWindLayer) {
        String suffix = "";
        String topSuffix = this.getSurfacePolygonWorldWindLayerSuffix((SurfacePolygonWorldWindLayer)airspaceWorldWindLayer);
        if (topSuffix.length() > 0) {
            suffix = String.valueOf(suffix) + topSuffix;
        }
        String altitudesSuffix = String.valueOf(this.format.format(airspaceWorldWindLayer.getLowerAltitude())) + "m, " + this.format.format(airspaceWorldWindLayer.getUpperAltitude()) + "m";
        if (topSuffix.length() > 0) {
            suffix = String.valueOf(suffix) + ", ";
        }
        suffix = String.valueOf(suffix) + altitudesSuffix;
        return suffix;
    }
}

