/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.scene_objects;

import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.asset.AssetManager;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.primitives.SpotLight;
import org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.JME3PrimitivesUtilities;
import org.eclipse.apogy.common.topology.addons.primitives.ui.scene_objects.SpotLightSceneObject;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotLightJME3SceneObject
extends DefaultJME3SceneObject<SpotLight>
implements SpotLightSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(SpotLightJME3SceneObject.class);
    public static ColorRGBA DEFAULT_LIGHT_CONE_COLOR = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    protected ColorRGBA fovColor = new ColorRGBA(0.0f, 1.0f, 0.0f, 0.25f);
    protected RGBA rgb = new RGBA(255, 255, 255, 255);
    public static final float INNER_TO_OUTER_SPREAD_RATIO = 1.8f;
    private MeshPresentationMode meshPresentationMode = MeshPresentationMode.WIREFRAME;
    protected boolean lightConeVisible = false;
    private float previousAxisLength = 1.0f;
    private boolean axisVisible = true;
    private Adapter adapter;
    private UpdateAppState updateAppState = null;
    public static float DEFAULT_POINT_LIGHT_RADIUS = 100.0f;
    private final AssetManager assetManager = this.jme3Application.getAssetManager();
    private Geometry fovGeometry = null;
    private Geometry axisGeometry = null;
    protected com.jme3.scene.Node lightConeNode;
    private com.jme3.light.SpotLight spotLight;

    public SpotLightJME3SceneObject(SpotLight topologyNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)topologyNode, jme3RenderEngineDelegate);
        this.jme3Application.getStateManager().attach((AppState)this.getUpdateAppState());
        this.axisGeometry = JME3Utilities.createAxis3D((float)1.0f, (AssetManager)this.assetManager);
        this.requestUpdate();
        topologyNode.eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.spotLight == null) {
            this.getSpotLight();
        }
        if (((SpotLight)this.getTopologyNode()).isEnabled()) {
            this.jme3Application.getRootNode().addLight((Light)this.spotLight);
        } else {
            this.jme3Application.getRootNode().removeLight((Light)this.spotLight);
        }
        if (this.fovGeometry != null) {
            this.getLightConeNode().detachChild((Spatial)this.fovGeometry);
        }
        float maxRange = ((SpotLight)this.getTopologyNode()).getSpotRange();
        Mesh mesh = JME3PrimitivesUtilities.createTruncatedCone(((SpotLight)this.getTopologyNode()).getSpreadAngle(), 0.01f, maxRange, 32);
        this.fovGeometry = ((SpotLight)this.getTopologyNode()).getNodeId() != null ? new Geometry(((SpotLight)this.getTopologyNode()).getNodeId(), mesh) : new Geometry("?", mesh);
        this.fovGeometry.setMaterial(this.createMaterial());
        this.getLightConeNode().attachChild((Spatial)this.fovGeometry);
        this.internalSetPresentationMode(this.meshPresentationMode);
    }

    public void setColor(RGBA rgb) {
        this.rgb = rgb;
        this.fovColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
        this.requestUpdate();
    }

    public RGBA getColor() {
        return this.rgb;
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((SpotLight)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        this.jme3Application.getStateManager().detach((AppState)this.getUpdateAppState());
        if (this.spotLight != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SpotLightJME3SceneObject.this.jme3Application.getRootNode().removeLight((Light)SpotLightJME3SceneObject.this.spotLight);
                    return null;
                }
            });
        }
        super.dispose();
    }

    public void setSpotSpreadAngle(final float spreadAngle) {
        Logger.info("Setting Spot Spread Angle<" + Math.toDegrees(spreadAngle) + "> degrees.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SpotLightJME3SceneObject.this.getSpotLight().setSpotInnerAngle(spreadAngle);
                SpotLightJME3SceneObject.this.getSpotLight().setSpotOuterAngle(spreadAngle * 1.8f);
                return null;
            }
        });
    }

    public void setSpotRange(final float spotRange) {
        Logger.info("Setting Spot Range <" + spotRange + "> meters.");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SpotLightJME3SceneObject.this.getSpotLight().setSpotRange(spotRange);
                return null;
            }
        });
    }

    public void setLightColor(RGBA color) {
        final ColorRGBA lightColor = JME3Utilities.convertToColorRGBA((RGBA)color);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SpotLightJME3SceneObject.this.getSpotLight().setColor(lightColor);
                return null;
            }
        });
    }

    public MeshPresentationMode getPresentationMode() {
        return this.meshPresentationMode;
    }

    public void setPresentationMode(final MeshPresentationMode mode) {
        this.meshPresentationMode = mode;
        if (this.fovGeometry != null && this.fovGeometry.getMaterial() != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SpotLightJME3SceneObject.this.internalSetPresentationMode(mode);
                    return null;
                }
            });
        }
    }

    public void setLightConeVisible(boolean visible) {
        Logger.info("Set Light Cone Visible <" + visible + ">.");
        this.lightConeVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (!SpotLightJME3SceneObject.this.lightConeVisible && SpotLightJME3SceneObject.this.getAttachmentNode().hasChild((Spatial)SpotLightJME3SceneObject.this.getLightConeNode())) {
                    SpotLightJME3SceneObject.this.getAttachmentNode().detachChild((Spatial)SpotLightJME3SceneObject.this.getLightConeNode());
                } else if (SpotLightJME3SceneObject.this.lightConeVisible && !SpotLightJME3SceneObject.this.getAttachmentNode().hasChild((Spatial)SpotLightJME3SceneObject.this.getLightConeNode())) {
                    SpotLightJME3SceneObject.this.getAttachmentNode().attachChild((Spatial)SpotLightJME3SceneObject.this.getLightConeNode());
                }
                return null;
            }
        });
    }

    public boolean isLightConeVisible() {
        return this.lightConeVisible;
    }

    public void setAxisVisible(boolean visible) {
        Logger.info("Setting axis visible to <" + visible + ">.");
        this.axisVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (SpotLightJME3SceneObject.this.axisVisible) {
                    SpotLightJME3SceneObject.this.getAttachmentNode().attachChild((Spatial)SpotLightJME3SceneObject.this.axisGeometry);
                } else {
                    SpotLightJME3SceneObject.this.getAttachmentNode().detachChild((Spatial)SpotLightJME3SceneObject.this.axisGeometry);
                }
                return null;
            }
        });
    }

    public void setAxisLength(final double length) {
        if (length > 0.0) {
            Logger.info("Setting axis length to <" + length + ">.");
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        float scale = (float)Math.abs(length) / SpotLightJME3SceneObject.this.previousAxisLength;
                        if (SpotLightJME3SceneObject.this.axisGeometry != null) {
                            SpotLightJME3SceneObject.this.axisGeometry.scale(scale);
                        }
                        SpotLightJME3SceneObject.this.previousAxisLength = (float)length;
                    }
                    catch (Throwable t) {
                        Logger.error("Failed to setAxisLength(" + length + ").", t);
                    }
                    return null;
                }
            });
        } else {
            Logger.error("Setting axis length to <" + length + "> failed : Length must be greater than zero.");
        }
    }

    private void setLightEnabled(final boolean enabled) {
        if (this.spotLight != null) {
            Logger.info("Setting Light Enabled <" + enabled + ">.");
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (enabled) {
                        if (!SpotLightJME3SceneObject.this.jme3Application.getRootNode().getChildren().contains(SpotLightJME3SceneObject.this.getSpotLight())) {
                            SpotLightJME3SceneObject.this.jme3Application.getRootNode().addLight((Light)SpotLightJME3SceneObject.this.getSpotLight());
                        }
                    } else {
                        SpotLightJME3SceneObject.this.jme3Application.getRootNode().removeLight((Light)SpotLightJME3SceneObject.this.getSpotLight());
                    }
                    return null;
                }
            });
        }
    }

    private com.jme3.light.SpotLight getSpotLight() {
        if (this.spotLight == null) {
            this.spotLight = new com.jme3.light.SpotLight();
            this.spotLight.setColor(ColorRGBA.White);
            this.spotLight.setSpotInnerAngle(((SpotLight)this.getTopologyNode()).getSpreadAngle());
            this.spotLight.setSpotOuterAngle(((SpotLight)this.getTopologyNode()).getSpreadAngle() * 1.8f);
            this.spotLight.setSpotRange(((SpotLight)this.getTopologyNode()).getSpotRange());
            Vector3f lightPosition = new Vector3f();
            if (this.getTopologyNode() != null) {
                Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(this.getTopologyNode());
                Vector3d position = new Vector3d();
                m.get(position);
                lightPosition = new Vector3f((float)position.x, (float)position.y, (float)position.z);
            }
            this.spotLight.setPosition(lightPosition);
            if (((SpotLight)this.getTopologyNode()).getNodeId() != null) {
                this.spotLight.setName(((SpotLight)this.getTopologyNode()).getNodeId());
            }
        }
        return this.spotLight;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof SpotLight) {
                        int featureID = msg.getFeatureID(SpotLight.class);
                        switch (featureID) {
                            case 4: {
                                SpotLightJME3SceneObject.this.setLightEnabled(msg.getNewBooleanValue());
                                break;
                            }
                            case 5: {
                                if (!(msg.getNewValue() instanceof RGBA)) break;
                                SpotLightJME3SceneObject.this.setLightColor((RGBA)msg.getNewValue());
                                break;
                            }
                            case 6: {
                                if (!(msg.getNewFloatValue() >= 0.0f)) break;
                                SpotLightJME3SceneObject.this.setSpotRange(msg.getNewFloatValue());
                                SpotLightJME3SceneObject.this.requestUpdate();
                                break;
                            }
                            case 7: {
                                if (!(msg.getNewFloatValue() >= 0.0f)) break;
                                SpotLightJME3SceneObject.this.setSpotSpreadAngle(msg.getNewFloatValue());
                                SpotLightJME3SceneObject.this.requestUpdate();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    protected UpdateAppState getUpdateAppState() {
        if (this.updateAppState == null) {
            this.updateAppState = new UpdateAppState();
        }
        return this.updateAppState;
    }

    private void internalSetPresentationMode(MeshPresentationMode mode) {
        if (this.fovGeometry != null && this.fovGeometry.getMesh() != null) {
            Mesh mesh = this.fovGeometry.getMesh();
            switch (mode.getValue()) {
                case 1: {
                    this.fovGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    if (mesh == null) break;
                    mesh.setMode(Mesh.Mode.Triangles);
                    break;
                }
                case 2: {
                    this.fovGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                    if (mesh == null) break;
                    mesh.setMode(Mesh.Mode.Triangles);
                    break;
                }
                case 0: {
                    this.fovGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    if (mesh == null) break;
                    mesh.setMode(Mesh.Mode.Points);
                    break;
                }
            }
        }
    }

    protected com.jme3.scene.Node getLightConeNode() {
        if (this.lightConeNode == null) {
            String name = null;
            name = this.getTopologyNode() != null && ((SpotLight)this.getTopologyNode()).getNodeId() != null ? ((SpotLight)this.getTopologyNode()).getNodeId() : ((Object)((Object)this)).getClass().getSimpleName();
            name = String.valueOf(name) + "_fov";
            this.lightConeNode = new com.jme3.scene.Node(name);
            this.getAttachmentNode().attachChild((Spatial)this.lightConeNode);
        }
        return this.lightConeNode;
    }

    private Material createMaterial() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.getColor() != null) {
            mat.setColor("Diffuse", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
            mat.setColor("Ambient", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
            mat.setColor("Specular", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
        } else {
            mat.setColor("Diffuse", DEFAULT_LIGHT_CONE_COLOR.clone());
            mat.setColor("Ambient", DEFAULT_LIGHT_CONE_COLOR.clone());
            mat.setColor("Specular", DEFAULT_LIGHT_CONE_COLOR.clone());
        }
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        return mat;
    }

    private class UpdateAppState
    extends AbstractAppState {
        private final Node root;

        public UpdateAppState() {
            this.root = ApogyCommonTopologyFacade.INSTANCE.findRoot(SpotLightJME3SceneObject.this.getTopologyNode());
        }

        public void update(float tpf) {
            Matrix4d newPose = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(SpotLightJME3SceneObject.this.getTopologyNode(), this.root);
            if (newPose != null) {
                Vector3d position = new Vector3d();
                newPose.get(position);
                Vector3d orientation = new Vector3d(0.0, 0.0, 1.0);
                Matrix3d rotation = new Matrix3d();
                newPose.get(rotation);
                rotation.transform((Tuple3d)orientation);
                orientation.normalize();
                SpotLightJME3SceneObject.this.getSpotLight().setPosition(new Vector3f((float)position.x, (float)position.y, (float)position.z));
                SpotLightJME3SceneObject.this.getSpotLight().setDirection(new Vector3f((float)orientation.x, (float)orientation.y, (float)orientation.z));
            }
            super.update(tpf);
        }
    }
}

