/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.jme3;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JME3PrimitivesUtilities {
    private static final Logger Logger = LoggerFactory.getLogger(JME3PrimitivesUtilities.class);

    public static Geometry createSphere(float radius, AssetManager assetManager) {
        Sphere sphere = new Sphere(10, 36, radius);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setBoolean("VertexColor", true);
        Geometry geometry = new Geometry("Sphere", (Mesh)sphere);
        geometry.setMaterial(mat);
        return geometry;
    }

    public static Mesh createSphericalCap(float radius, float minElevationAngle, float maxElevationAngle, int numberOfFaces) {
        return JME3PrimitivesUtilities.createSphericalCap(radius, minElevationAngle, maxElevationAngle, numberOfFaces, 0.0f);
    }

    public static Mesh createSphericalCap(float radius, float minElevationAngle, float maxElevationAngle, int numberOfFaces, float zTranslation) {
        Mesh mesh = null;
        try {
            ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
            ArrayList<Integer> indexesList = new ArrayList<Integer>();
            ArrayList<Vector3f> normalslList = new ArrayList<Vector3f>();
            if (maxElevationAngle - minElevationAngle > 0.0f) {
                int verticeIndex = 0;
                double apexAngle = minElevationAngle;
                double elevationIncrement = (maxElevationAngle - minElevationAngle) / (float)numberOfFaces;
                int j = 0;
                while (j < numberOfFaces) {
                    double radiusNear = (double)radius * Math.cos(apexAngle);
                    double radiusFar = (double)radius * Math.cos(apexAngle + elevationIncrement);
                    double zNear = (double)radius * Math.sin(apexAngle) + (double)zTranslation;
                    double zFar = (double)radius * Math.sin(apexAngle + elevationIncrement) + (double)zTranslation;
                    double angleIncrement = Math.toRadians(360.0) / (double)numberOfFaces;
                    int i = 0;
                    while (i < numberOfFaces) {
                        double angle = (double)i * angleIncrement;
                        double x1Near = radiusNear * Math.cos(angle);
                        double y1Near = radiusNear * Math.sin(angle);
                        double x1Far = radiusFar * Math.cos(angle);
                        double y1Far = radiusFar * Math.sin(angle);
                        Vector3f point1Near = new Vector3f((float)x1Near, (float)y1Near, (float)zNear);
                        Vector3f point1Far = new Vector3f((float)x1Far, (float)y1Far, (float)zFar);
                        double x2Near = radiusNear * Math.cos(angle + angleIncrement);
                        double y2Near = radiusNear * Math.sin(angle + angleIncrement);
                        double x2Far = radiusFar * Math.cos(angle + angleIncrement);
                        double y2Far = radiusFar * Math.sin(angle + angleIncrement);
                        Vector3f point2Near = new Vector3f((float)x2Near, (float)y2Near, (float)zNear);
                        Vector3f point2Far = new Vector3f((float)x2Far, (float)y2Far, (float)zFar);
                        verticesList.add(point1Near);
                        indexesList.add(new Integer(verticeIndex));
                        verticesList.add(point1Far);
                        indexesList.add(new Integer(++verticeIndex));
                        verticesList.add(point2Far);
                        indexesList.add(new Integer(++verticeIndex));
                        ++verticeIndex;
                        Vector3f normal1 = JME3Utilities.computeTriangleNormal((Vector3f)point1Near, (Vector3f)point1Far, (Vector3f)point2Far);
                        normalslList.add(normal1);
                        normalslList.add(normal1);
                        normalslList.add(normal1);
                        verticesList.add(point1Near);
                        indexesList.add(new Integer(verticeIndex));
                        verticesList.add(point2Far);
                        indexesList.add(new Integer(++verticeIndex));
                        verticesList.add(point2Near);
                        indexesList.add(new Integer(++verticeIndex));
                        ++verticeIndex;
                        Vector3f normal2 = JME3Utilities.computeTriangleNormal((Vector3f)point1Near, (Vector3f)point2Far, (Vector3f)point2Near);
                        normalslList.add(normal2);
                        normalslList.add(normal2);
                        normalslList.add(normal2);
                        ++i;
                    }
                    apexAngle += elevationIncrement;
                    ++j;
                }
            }
            mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
            mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(normalslList)));
            mesh.updateBound();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return mesh;
    }

    public static Mesh createTruncatedCone(float apexAngle, float minRadius, float maxRadius, int numberOfFaces) {
        Mesh mesh = null;
        try {
            ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
            ArrayList<Integer> indexesList = new ArrayList<Integer>();
            ArrayList<Vector3f> normalslList = new ArrayList<Vector3f>();
            if (apexAngle > 0.0f) {
                int verticeIndex = 0;
                double currentApexAngle = apexAngle;
                double radiusNear = (double)minRadius * Math.sin(currentApexAngle / 2.0);
                double radiusFar = (double)maxRadius * Math.sin(currentApexAngle / 2.0);
                double zNear = (double)minRadius * Math.cos(currentApexAngle / 2.0);
                double zFar = (double)maxRadius * Math.cos(currentApexAngle / 2.0);
                double angleIncrement = Math.toRadians(360.0) / (double)numberOfFaces;
                int i = 0;
                while (i < numberOfFaces) {
                    double angle = (double)i * angleIncrement;
                    double x1Near = radiusNear * Math.cos(angle);
                    double y1Near = radiusNear * Math.sin(angle);
                    double x1Far = radiusFar * Math.cos(angle);
                    double y1Far = radiusFar * Math.sin(angle);
                    Vector3f point1Near = new Vector3f((float)x1Near, (float)y1Near, (float)zNear);
                    Vector3f point1Far = new Vector3f((float)x1Far, (float)y1Far, (float)zFar);
                    double x2Near = radiusNear * Math.cos(angle + angleIncrement);
                    double y2Near = radiusNear * Math.sin(angle + angleIncrement);
                    double x2Far = radiusFar * Math.cos(angle + angleIncrement);
                    double y2Far = radiusFar * Math.sin(angle + angleIncrement);
                    Vector3f point2Near = new Vector3f((float)x2Near, (float)y2Near, (float)zNear);
                    Vector3f point2Far = new Vector3f((float)x2Far, (float)y2Far, (float)zFar);
                    verticesList.add(point1Near);
                    indexesList.add(new Integer(verticeIndex));
                    verticesList.add(point1Far);
                    indexesList.add(new Integer(++verticeIndex));
                    verticesList.add(point2Far);
                    indexesList.add(new Integer(++verticeIndex));
                    ++verticeIndex;
                    Vector3f normal1 = JME3Utilities.computeTriangleNormal((Vector3f)point1Near, (Vector3f)point1Far, (Vector3f)point2Far);
                    normalslList.add(normal1);
                    normalslList.add(normal1);
                    normalslList.add(normal1);
                    verticesList.add(point1Near);
                    indexesList.add(new Integer(verticeIndex));
                    verticesList.add(point2Far);
                    indexesList.add(new Integer(++verticeIndex));
                    verticesList.add(point2Near);
                    indexesList.add(new Integer(++verticeIndex));
                    ++verticeIndex;
                    Vector3f normal2 = JME3Utilities.computeTriangleNormal((Vector3f)point1Near, (Vector3f)point2Far, (Vector3f)point2Near);
                    normalslList.add(normal2);
                    normalslList.add(normal2);
                    normalslList.add(normal2);
                    ++i;
                }
            } else {
                verticesList.add(new Vector3f(minRadius, 0.0f, 0.0f));
                verticesList.add(new Vector3f(maxRadius, 0.0f, 0.0f));
                indexesList.add(new Integer(0));
                indexesList.add(new Integer(1));
                indexesList.add(new Integer(0));
                normalslList.add(new Vector3f(0.0f, 0.0f, 1.0f));
            }
            mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
            mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(normalslList)));
            mesh.updateBound();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return mesh;
    }
}

