/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.atmosphere.impl;

import java.util.Date;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.Sky;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.WorksiteNode;
import org.eclipse.apogy.core.environment.earth.atmosphere.ApogyEarthAtmosphereEnvironmentFactory;
import org.eclipse.apogy.core.environment.earth.atmosphere.EarthAtmosphereWorksiteNode;
import org.eclipse.apogy.core.environment.earth.atmosphere.impl.EarthAtmosphereWorksiteImpl;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.apogy.core.environment.earth.surface.AtmosphereUtils;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EarthAtmosphereWorksiteCustomImpl
extends EarthAtmosphereWorksiteImpl {
    @Override
    public EarthSky getEarthSky() {
        EarthSky es = super.getEarthSky();
        if (es == null) {
            es = ApogyEarthSurfaceEnvironmentFactory.eINSTANCE.createEarthSky();
            this.setSky((Sky)es);
        }
        return es;
    }

    @Override
    public EarthSky basicGetEarthSky() {
        return (EarthSky)super.getSky();
    }

    @Override
    public void setEarthSky(EarthSky newEarthSky) {
        super.setSky((Sky)newEarthSky);
    }

    public void setSky(Sky newSky) {
        EarthAtmosphereWorksiteNode earthSurfaceWorksiteNode;
        if (this.getSky() != null && this.getWorksiteNode() instanceof EarthAtmosphereWorksiteNode) {
            earthSurfaceWorksiteNode = (EarthAtmosphereWorksiteNode)this.getWorksiteNode();
            earthSurfaceWorksiteNode.getSkyTransformNode().getChildren().remove((Object)this.getSky().getSkyNode());
            earthSurfaceWorksiteNode.getChildren().remove((Object)this.getSky().getSkyNode());
        }
        super.setSky(newSky);
        if (newSky != null && this.getWorksiteNode() instanceof EarthAtmosphereWorksiteNode) {
            earthSurfaceWorksiteNode = (EarthAtmosphereWorksiteNode)this.getWorksiteNode();
            earthSurfaceWorksiteNode.getSkyTransformNode().getChildren().add((Object)newSky.getSkyNode());
        }
    }

    public WorksiteNode getWorksiteNode() {
        if (!(super.getWorksiteNode() instanceof EarthAtmosphereWorksiteNode)) {
            this.worksiteNode = ApogyEarthAtmosphereEnvironmentFactory.eINSTANCE.createEarthAtmosphereWorksiteNode();
            this.worksiteNode.setWorksite((Worksite)this);
            this.worksiteNode.setNodeId(this.getName().replaceAll(" ", "_"));
            this.worksiteNode.setDescription("Root Node of the Worksite");
        }
        return this.worksiteNode;
    }

    public void setTime(Date newTime) {
        super.setTime(newTime);
        this.updateSunIntensity(newTime);
    }

    private void updateSunIntensity(Date newTime) {
        if (this.getGeographicalCoordinates() != null && this.getEarthSky() != null) {
            HorizontalCoordinates sunCoordinates = AstronomyUtils.INSTANCE.getHorizontalSunPosition(newTime, this.getGeographicalCoordinates().getLongitude(), this.getGeographicalCoordinates().getLatitude());
            Double value = AtmosphereUtils.INSTANCE.getDirectSunIntensity(sunCoordinates.getAltitude(), this.getGeographicalCoordinates().getElevation());
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.WORKSITE__SUN_IRRADIANCE, (Object)value, true);
        }
    }
}

