/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.common.emf.ValidityTimeRange;
import org.eclipse.apogy.core.environment.orbit.AbstractFrame;
import org.eclipse.apogy.core.environment.orbit.ApogyCoreEnvironmentOrbitPackage;
import org.eclipse.apogy.core.environment.orbit.AttitudeProvider;
import org.eclipse.apogy.core.environment.orbit.OrbitModel;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.apogy.core.environment.orbit.impl.AbstractOrbitModelImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class OrbitModelImpl
extends AbstractOrbitModelImpl
implements OrbitModel {
    protected static final Date FROM_DATE_EDEFAULT = null;
    protected Date fromDate = FROM_DATE_EDEFAULT;
    protected static final Date TO_DATE_EDEFAULT = null;
    protected Date toDate = TO_DATE_EDEFAULT;
    protected AbstractFrame referenceFrame;
    protected EList<AttitudeProvider> attitudeProvider;

    protected OrbitModelImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ApogyCoreEnvironmentOrbitPackage.Literals.ORBIT_MODEL;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date newFromDate) {
        Date oldFromDate = this.fromDate;
        this.fromDate = newFromDate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldFromDate, (Object)this.fromDate));
        }
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date newToDate) {
        Date oldToDate = this.toDate;
        this.toDate = newToDate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldToDate, (Object)this.toDate));
        }
    }

    @Override
    public AbstractFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public NotificationChain basicSetReferenceFrame(AbstractFrame newReferenceFrame, NotificationChain msgs) {
        AbstractFrame oldReferenceFrame = this.referenceFrame;
        this.referenceFrame = newReferenceFrame;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldReferenceFrame, (Object)newReferenceFrame);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setReferenceFrame(AbstractFrame newReferenceFrame) {
        if (newReferenceFrame != this.referenceFrame) {
            NotificationChain msgs = null;
            if (this.referenceFrame != null) {
                msgs = ((InternalEObject)this.referenceFrame).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newReferenceFrame != null) {
                msgs = ((InternalEObject)newReferenceFrame).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetReferenceFrame(newReferenceFrame, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newReferenceFrame, (Object)newReferenceFrame));
        }
    }

    @Override
    public EList<AttitudeProvider> getAttitudeProvider() {
        if (this.attitudeProvider == null) {
            this.attitudeProvider = new EObjectContainmentEList(AttitudeProvider.class, (InternalEObject)this, 3);
        }
        return this.attitudeProvider;
    }

    @Override
    public SpacecraftState propagate(Date targetDate) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SpacecraftState> getSpacecraftStates(Date startDate, Date endDate, double timeInterval) throws Exception {
        throw new UnsupportedOperationException();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetReferenceFrame(null, msgs);
            }
            case 3: {
                return ((InternalEList)this.getAttitudeProvider()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getFromDate();
            }
            case 1: {
                return this.getToDate();
            }
            case 2: {
                return this.getReferenceFrame();
            }
            case 3: {
                return this.getAttitudeProvider();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setFromDate((Date)newValue);
                return;
            }
            case 1: {
                this.setToDate((Date)newValue);
                return;
            }
            case 2: {
                this.setReferenceFrame((AbstractFrame)newValue);
                return;
            }
            case 3: {
                this.getAttitudeProvider().clear();
                this.getAttitudeProvider().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setFromDate(FROM_DATE_EDEFAULT);
                return;
            }
            case 1: {
                this.setToDate(TO_DATE_EDEFAULT);
                return;
            }
            case 2: {
                this.setReferenceFrame(null);
                return;
            }
            case 3: {
                this.getAttitudeProvider().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return FROM_DATE_EDEFAULT == null ? this.fromDate != null : !FROM_DATE_EDEFAULT.equals(this.fromDate);
            }
            case 1: {
                return TO_DATE_EDEFAULT == null ? this.toDate != null : !TO_DATE_EDEFAULT.equals(this.toDate);
            }
            case 2: {
                return this.referenceFrame != null;
            }
            case 3: {
                return this.attitudeProvider != null && !this.attitudeProvider.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == TimeInterval.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == ValidityTimeRange.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == TimeInterval.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == ValidityTimeRange.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                try {
                    return this.propagate((Date)arguments.get(0));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 1: {
                try {
                    return this.getSpacecraftStates((Date)arguments.get(0), (Date)arguments.get(1), (Double)arguments.get(2));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (fromDate: ");
        result.append(this.fromDate);
        result.append(", toDate: ");
        result.append(this.toDate);
        result.append(')');
        return result.toString();
    }
}

