/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils;

import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JME3FovUtilities {
    private static final Logger Logger = LoggerFactory.getLogger(JME3FovUtilities.class);

    public static Mesh createCircularSector(double minAngle, double maxAngle, double minRadius, double maxRadius, int numberOfDivisions, boolean generateNormals) {
        Mesh mesh = null;
        try {
            ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
            ArrayList<Integer> indexesList = new ArrayList<Integer>();
            ArrayList<Vector3f> normalslList = new ArrayList<Vector3f>();
            double angleIncrement = (maxAngle - minAngle) / (double)numberOfDivisions;
            if (maxRadius - minRadius > 0.0 && angleIncrement > 0.0) {
                int verticeIndex = 0;
                double angle = minAngle;
                int verticesCount = 0;
                int side = 0;
                while (side < 2) {
                    angle = minAngle;
                    verticesCount = 0;
                    int i = 0;
                    while (i < numberOfDivisions) {
                        double y1Near = minRadius * Math.sin(angle);
                        double z1Near = minRadius * Math.cos(angle);
                        double y1Far = maxRadius * Math.sin(angle);
                        double z1Far = maxRadius * Math.cos(angle);
                        Vector3f point1Near = new Vector3f(0.0f, (float)y1Near, (float)z1Near);
                        Vector3f point1Far = new Vector3f(0.0f, (float)y1Far, (float)z1Far);
                        double nextAngle = angle + angleIncrement;
                        double y2Near = minRadius * Math.sin(nextAngle);
                        double z2Near = minRadius * Math.cos(nextAngle);
                        double y2Far = maxRadius * Math.sin(nextAngle);
                        double z2Far = maxRadius * Math.cos(nextAngle);
                        Vector3f point2Near = new Vector3f(0.0f, (float)y2Near, (float)z2Near);
                        Vector3f point2Far = new Vector3f(0.0f, (float)y2Far, (float)z2Far);
                        verticesList.add(point1Near);
                        indexesList.add(new Integer(verticeIndex));
                        verticesList.add(point1Far);
                        indexesList.add(new Integer(++verticeIndex));
                        verticesList.add(point2Far);
                        indexesList.add(new Integer(++verticeIndex));
                        verticesList.add(point1Near);
                        indexesList.add(new Integer(++verticeIndex));
                        verticesList.add(point2Far);
                        indexesList.add(new Integer(++verticeIndex));
                        verticesList.add(point2Near);
                        indexesList.add(new Integer(++verticeIndex));
                        ++verticeIndex;
                        verticesCount += 6;
                        angle += angleIncrement;
                        ++i;
                    }
                    i = 0;
                    while (i < verticesCount) {
                        if (side == 0) {
                            normalslList.add(new Vector3f(1.0f, 0.0f, 0.0f));
                        } else {
                            normalslList.add(new Vector3f(-1.0f, 0.0f, 0.0f));
                        }
                        ++i;
                    }
                    ++side;
                }
            } else {
                verticesList.add(new Vector3f(0.0f, 0.0f, (float)minRadius));
                verticesList.add(new Vector3f(0.0f, 0.0f, (float)maxRadius));
                indexesList.add(new Integer(0));
                indexesList.add(new Integer(1));
                indexesList.add(new Integer(0));
                normalslList.add(new Vector3f(1.0f, 0.0f, 0.0f));
            }
            mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
            mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            if (generateNormals) {
                mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(normalslList)));
            }
            mesh.updateBound();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return mesh;
    }

    public static Mesh createTruncatedCone(float apexAngle, float minRadius, float maxRadius, int numberOfFaces) {
        Mesh mesh = null;
        try {
            ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
            ArrayList<Integer> indexesList = new ArrayList<Integer>();
            ArrayList<Vector3f> normalslList = new ArrayList<Vector3f>();
            if (apexAngle > 0.0f) {
                int verticeIndex = 0;
                double currentApexAngle = apexAngle;
                double radiusNear = (double)minRadius * Math.sin(currentApexAngle / 2.0);
                double radiusFar = (double)maxRadius * Math.sin(currentApexAngle / 2.0);
                double zNear = (double)minRadius * Math.cos(currentApexAngle / 2.0);
                double zFar = (double)maxRadius * Math.cos(currentApexAngle / 2.0);
                double angleIncrement = Math.toRadians(360.0) / (double)numberOfFaces;
                int i = 0;
                while (i < numberOfFaces) {
                    double angle = (double)i * angleIncrement;
                    double x1Near = radiusNear * Math.cos(angle);
                    double y1Near = radiusNear * Math.sin(angle);
                    double x1Far = radiusFar * Math.cos(angle);
                    double y1Far = radiusFar * Math.sin(angle);
                    Vector3f point1Near = new Vector3f((float)x1Near, (float)y1Near, (float)zNear);
                    Vector3f point1Far = new Vector3f((float)x1Far, (float)y1Far, (float)zFar);
                    double x2Near = radiusNear * Math.cos(angle + angleIncrement);
                    double y2Near = radiusNear * Math.sin(angle + angleIncrement);
                    double x2Far = radiusFar * Math.cos(angle + angleIncrement);
                    double y2Far = radiusFar * Math.sin(angle + angleIncrement);
                    Vector3f point2Near = new Vector3f((float)x2Near, (float)y2Near, (float)zNear);
                    Vector3f point2Far = new Vector3f((float)x2Far, (float)y2Far, (float)zFar);
                    verticesList.add(point1Near);
                    indexesList.add(new Integer(verticeIndex));
                    verticesList.add(point1Far);
                    indexesList.add(new Integer(++verticeIndex));
                    verticesList.add(point2Far);
                    indexesList.add(new Integer(++verticeIndex));
                    ++verticeIndex;
                    Vector3f normal1 = JME3Utilities.computeTriangleNormal((Vector3f)point1Near, (Vector3f)point1Far, (Vector3f)point2Far);
                    normalslList.add(normal1);
                    normalslList.add(normal1);
                    normalslList.add(normal1);
                    verticesList.add(point1Near);
                    indexesList.add(new Integer(verticeIndex));
                    verticesList.add(point2Far);
                    indexesList.add(new Integer(++verticeIndex));
                    verticesList.add(point2Near);
                    indexesList.add(new Integer(++verticeIndex));
                    ++verticeIndex;
                    Vector3f normal2 = JME3Utilities.computeTriangleNormal((Vector3f)point1Near, (Vector3f)point2Far, (Vector3f)point2Near);
                    normalslList.add(normal2);
                    normalslList.add(normal2);
                    normalslList.add(normal2);
                    ++i;
                }
            } else {
                verticesList.add(new Vector3f(minRadius, 0.0f, 0.0f));
                verticesList.add(new Vector3f(maxRadius, 0.0f, 0.0f));
                indexesList.add(new Integer(0));
                indexesList.add(new Integer(1));
                indexesList.add(new Integer(0));
                normalslList.add(new Vector3f(0.0f, 0.0f, 1.0f));
            }
            mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
            mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(normalslList)));
            mesh.updateBound();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return mesh;
    }

    public static Mesh createRectangularFrustum(RectangularFrustrumFieldOfView fov, int numberHorizontalIncrement, int numberVerticalIncrement) {
        float minRadius = (float)fov.getRange().getMinimumDistance();
        float maxRadius = (float)fov.getRange().getMaximumDistance();
        float minHorizontalAngle = (float)(fov.getHorizontalFieldOfViewAngle() / -2.0);
        float maxHorizontalAngle = (float)(fov.getHorizontalFieldOfViewAngle() / 2.0);
        float minVerticalAngle = (float)(fov.getVerticalFieldOfViewAngle() / -2.0);
        float maxVerticalAngle = (float)(fov.getVerticalFieldOfViewAngle() / 2.0);
        return JME3FovUtilities.createRectangularFrustum(minRadius, maxRadius, minHorizontalAngle, maxHorizontalAngle, minVerticalAngle, maxVerticalAngle, numberHorizontalIncrement, numberVerticalIncrement);
    }

    public static Mesh createRectangularFrustum(float minRadius, float maxRadius, float minHorizontalAngle, float maxHorizontalAngle, float minVerticalAngle, float maxVerticalAngle, int numberHorizontalIncrement, int numberVerticalIncrement) {
        Mesh mesh = null;
        try {
            ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
            ArrayList<Integer> indexesList = new ArrayList<Integer>();
            ArrayList<Vector3f> normalslList = new ArrayList<Vector3f>();
            JME3FovUtilities.generateHorizontalFace(verticesList, indexesList, normalslList, minRadius, maxRadius, minVerticalAngle, minHorizontalAngle, maxHorizontalAngle, numberHorizontalIncrement);
            JME3FovUtilities.generateHorizontalFace(verticesList, indexesList, normalslList, minRadius, maxRadius, maxVerticalAngle, minHorizontalAngle, maxHorizontalAngle, numberHorizontalIncrement);
            JME3FovUtilities.generateVerticalFace(verticesList, indexesList, normalslList, minRadius, maxRadius, minHorizontalAngle, minVerticalAngle, maxVerticalAngle, numberVerticalIncrement);
            JME3FovUtilities.generateVerticalFace(verticesList, indexesList, normalslList, minRadius, maxRadius, maxHorizontalAngle, minVerticalAngle, maxVerticalAngle, numberVerticalIncrement);
            JME3FovUtilities.generateEndFace(verticesList, indexesList, normalslList, minRadius, minHorizontalAngle, maxHorizontalAngle, minVerticalAngle, maxVerticalAngle, numberHorizontalIncrement, numberVerticalIncrement, false);
            JME3FovUtilities.generateEndFace(verticesList, indexesList, normalslList, maxRadius, minHorizontalAngle, maxHorizontalAngle, minVerticalAngle, maxVerticalAngle, numberHorizontalIncrement, numberVerticalIncrement, true);
            mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
            mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(normalslList)));
            mesh.updateBound();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return mesh;
    }

    public static void generateHorizontalFace(List<Vector3f> verticesList, List<Integer> indexesList, List<Vector3f> normalslList, float minRadius, float maxRadius, float elevationAngle, float minHorizontalAngle, float maxHorizontalAngle, int numberHorizontalIncrement) {
        List<Vector3f> near = JME3FovUtilities.generateHorizontalProfile(minRadius, elevationAngle, minHorizontalAngle, maxHorizontalAngle, numberHorizontalIncrement);
        List<Vector3f> far = JME3FovUtilities.generateHorizontalProfile(maxRadius, elevationAngle, minHorizontalAngle, maxHorizontalAngle, numberHorizontalIncrement);
        int verticeIndex = indexesList.size() - 1;
        int i = 0;
        while (i < near.size() - 1) {
            verticesList.add(near.get(i));
            indexesList.add(new Integer(++verticeIndex));
            verticesList.add(near.get(i + 1));
            indexesList.add(new Integer(++verticeIndex));
            verticesList.add(far.get(i + 1));
            indexesList.add(new Integer(++verticeIndex));
            Vector3f normal1 = JME3Utilities.computeTriangleNormal((Vector3f)near.get(i), (Vector3f)near.get(i + 1), (Vector3f)far.get(i + 1));
            normalslList.add(normal1);
            normalslList.add(normal1);
            normalslList.add(normal1);
            verticesList.add(near.get(i));
            indexesList.add(new Integer(++verticeIndex));
            verticesList.add(far.get(i + 1));
            indexesList.add(new Integer(++verticeIndex));
            verticesList.add(far.get(i));
            indexesList.add(new Integer(++verticeIndex));
            Vector3f normal2 = JME3Utilities.computeTriangleNormal((Vector3f)near.get(i), (Vector3f)far.get(i + 1), (Vector3f)far.get(i));
            normalslList.add(normal2);
            normalslList.add(normal2);
            normalslList.add(normal2);
            ++i;
        }
    }

    public static void generateVerticalFace(List<Vector3f> verticesList, List<Integer> indexesList, List<Vector3f> normalslList, float minRadius, float maxRadius, float azimuthAngle, float minVerticalAngle, float maxVerticalAngle, int numberVerticalIncrement) {
        List<Vector3f> near = JME3FovUtilities.generateVerticalProfile(minRadius, azimuthAngle, minVerticalAngle, maxVerticalAngle, numberVerticalIncrement);
        List<Vector3f> far = JME3FovUtilities.generateVerticalProfile(maxRadius, azimuthAngle, minVerticalAngle, maxVerticalAngle, numberVerticalIncrement);
        int verticeIndex = indexesList.size() - 1;
        int i = 0;
        while (i < near.size() - 1) {
            verticesList.add(near.get(i));
            indexesList.add(new Integer(++verticeIndex));
            verticesList.add(near.get(i + 1));
            indexesList.add(new Integer(++verticeIndex));
            verticesList.add(far.get(i + 1));
            indexesList.add(new Integer(++verticeIndex));
            Vector3f normal1 = JME3Utilities.computeTriangleNormal((Vector3f)near.get(i), (Vector3f)near.get(i + 1), (Vector3f)far.get(i + 1));
            normalslList.add(normal1);
            normalslList.add(normal1);
            normalslList.add(normal1);
            verticesList.add(near.get(i));
            indexesList.add(new Integer(++verticeIndex));
            verticesList.add(far.get(i + 1));
            indexesList.add(new Integer(++verticeIndex));
            verticesList.add(far.get(i));
            indexesList.add(new Integer(++verticeIndex));
            Vector3f normal2 = JME3Utilities.computeTriangleNormal((Vector3f)near.get(i), (Vector3f)far.get(i + 1), (Vector3f)far.get(i));
            normalslList.add(normal2);
            normalslList.add(normal2);
            normalslList.add(normal2);
            ++i;
        }
    }

    private static List<Vector3f> generateHorizontalProfile(float radius, float elevationAngle, float minHorizontalAngle, float maxHorizontalAngle, int numberHorizontalIncrement) {
        ArrayList<Vector3f> vertices = new ArrayList<Vector3f>();
        double azimuthAngleIncrement = (maxHorizontalAngle - minHorizontalAngle) / (float)(numberHorizontalIncrement - 1);
        double azimuthAngle = minHorizontalAngle;
        float l = (float)((double)radius * Math.cos(elevationAngle));
        int azimuth = 0;
        while (azimuth < numberHorizontalIncrement) {
            float x = (float)((double)radius * Math.sin(elevationAngle));
            float y = (float)((double)l * Math.sin(azimuthAngle));
            float z = (float)((double)l * Math.cos(azimuthAngle));
            vertices.add(new Vector3f(x, y, z));
            azimuthAngle += azimuthAngleIncrement;
            ++azimuth;
        }
        return vertices;
    }

    private static List<Vector3f> generateVerticalProfile(float radius, float azimuthAngle, float minVerticalAngle, float maxVerticalAngle, int numberVerticalIncrement) {
        ArrayList<Vector3f> vertices = new ArrayList<Vector3f>();
        double elevationAngleIncrement = (maxVerticalAngle - minVerticalAngle) / (float)(numberVerticalIncrement - 1);
        double elevationAngle = minVerticalAngle;
        int elevation = 0;
        while (elevation < numberVerticalIncrement) {
            float l = (float)((double)radius * Math.cos(elevationAngle));
            float x = (float)((double)radius * Math.sin(elevationAngle));
            float y = (float)((double)l * Math.sin(azimuthAngle));
            float z = (float)((double)l * Math.cos(azimuthAngle));
            vertices.add(new Vector3f(x, y, z));
            elevationAngle += elevationAngleIncrement;
            ++elevation;
        }
        return vertices;
    }

    public static void generateEndFace(List<Vector3f> verticesList, List<Integer> indexesList, List<Vector3f> normalslList, float radius, float minHorizontalAngle, float maxHorizontalAngle, float minVerticalAngle, float maxVerticalAngle, int numberHorizontalIncrement, int numberVerticalIncrement, boolean invertNormals) {
        int verticeIndex = indexesList.size() - 1;
        double elevationAngleIncrement = (maxVerticalAngle - minVerticalAngle) / (float)(numberVerticalIncrement - 1);
        double azimuthAngleIncrement = (maxHorizontalAngle - minHorizontalAngle) / (float)(numberHorizontalIncrement - 1);
        Vector3f[][] verticesArray = new Vector3f[numberVerticalIncrement][numberHorizontalIncrement];
        double elevationAngle = minVerticalAngle;
        int elevation = 0;
        while (elevation < numberVerticalIncrement) {
            double azimuthAngle = minHorizontalAngle;
            int azimuth = 0;
            while (azimuth < numberHorizontalIncrement) {
                float l = (float)((double)radius * Math.cos(elevationAngle));
                float x = (float)((double)radius * Math.sin(elevationAngle));
                float y = (float)((double)l * Math.sin(azimuthAngle));
                float z = (float)((double)l * Math.cos(azimuthAngle));
                verticesArray[elevation][azimuth] = new Vector3f(x, y, z);
                azimuthAngle += azimuthAngleIncrement;
                ++azimuth;
            }
            elevationAngle += elevationAngleIncrement;
            ++elevation;
        }
        elevation = 0;
        while (elevation < numberVerticalIncrement - 1) {
            int azimuth = 0;
            while (azimuth < numberHorizontalIncrement - 1) {
                Vector3f p0 = verticesArray[elevation][azimuth];
                Vector3f p1 = verticesArray[elevation][azimuth + 1];
                Vector3f p2 = verticesArray[elevation + 1][azimuth + 1];
                verticesList.add(p0);
                indexesList.add(new Integer(++verticeIndex));
                verticesList.add(p1);
                indexesList.add(new Integer(++verticeIndex));
                verticesList.add(p2);
                indexesList.add(new Integer(++verticeIndex));
                Vector3f normal1 = null;
                normal1 = invertNormals ? JME3Utilities.computeTriangleNormal((Vector3f)p2, (Vector3f)p1, (Vector3f)p0) : JME3Utilities.computeTriangleNormal((Vector3f)p0, (Vector3f)p1, (Vector3f)p2);
                normalslList.add(normal1);
                normalslList.add(normal1);
                normalslList.add(normal1);
                p0 = verticesArray[elevation][azimuth];
                p1 = verticesArray[elevation + 1][azimuth + 1];
                p2 = verticesArray[elevation + 1][azimuth];
                verticesList.add(p0);
                indexesList.add(new Integer(++verticeIndex));
                verticesList.add(p1);
                indexesList.add(new Integer(++verticeIndex));
                verticesList.add(p2);
                indexesList.add(new Integer(++verticeIndex));
                Vector3f normal2 = null;
                normal2 = invertNormals ? JME3Utilities.computeTriangleNormal((Vector3f)p2, (Vector3f)p1, (Vector3f)p0) : JME3Utilities.computeTriangleNormal((Vector3f)p0, (Vector3f)p1, (Vector3f)p2);
                normalslList.add(normal2);
                normalslList.add(normal2);
                normalslList.add(normal2);
                ++azimuth;
            }
            ++elevation;
        }
    }

    public static GeometryList createGeometryListForImageProjection(JME3Application jme3Application) {
        GeometryList geometryList = new GeometryList(new GeometryComparator(){

            public int compare(Geometry arg0, Geometry arg1) {
                if (arg0.queueDistance > arg1.queueDistance) {
                    return 1;
                }
                if (arg0.queueDistance < arg1.queueDistance) {
                    return -1;
                }
                return 0;
            }

            public void setCamera(Camera arg0) {
            }
        });
        return geometryList;
    }

    public static void updateGeometryListForImageProjection(JME3RenderEngineDelegate jme3RenderEngineDelegate, GeometryList geometryList) {
        geometryList.clear();
        try {
            JME3FovUtilities.findGeometry(jme3RenderEngineDelegate, geometryList, (Spatial)jme3RenderEngineDelegate.getJME3Application().getRootNode());
        }
        catch (Throwable throwable) {}
    }

    private static void findGeometry(JME3RenderEngineDelegate jme3RenderEngineDelegate, GeometryList geometryList, Spatial spatial) {
        if (spatial instanceof Geometry) {
            Geometry geometry = (Geometry)spatial;
            Node node = jme3RenderEngineDelegate.getTopologyNode(geometry);
            NodePresentation nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode(node);
            if (nodePresentation != null && nodePresentation.isEnableTextureProjection()) {
                geometryList.add(geometry);
            }
        }
        if (spatial instanceof com.jme3.scene.Node) {
            com.jme3.scene.Node node = (com.jme3.scene.Node)spatial;
            for (Spatial child : node.getChildren()) {
                JME3FovUtilities.findGeometry(jme3RenderEngineDelegate, geometryList, child);
            }
        }
    }
}

