/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects;

import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.sensors.fov.FieldOfView;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.AbstractFieldOfViewImageProjectorControl;
import org.eclipse.apogy.addons.sensors.fov.ui.scene_objects.FieldOfViewSceneObject;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFieldOfViewJME3Object<R extends FieldOfView>
extends DefaultJME3SceneObject<R>
implements FieldOfViewSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractFieldOfViewJME3Object.class);
    protected MeshPresentationMode meshPresentationMode = MeshPresentationMode.WIREFRAME;
    protected float transparency = 0.0f;
    protected boolean showProjection = false;
    protected boolean fovVisible = false;
    protected boolean showOutlineOnly = false;
    protected ColorRGBA fovColor = new ColorRGBA(0.0f, 1.0f, 0.0f, 0.25f);
    protected RGBA rgb = new RGBA(255, 255, 255, 255);
    protected RGB projectionColor = new RGB(1, 1, 1);
    protected Node fovNode;

    public AbstractFieldOfViewJME3Object(R topologyNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super(topologyNode, jme3RenderEngineDelegate);
    }

    public void setColor(RGBA rgb) {
        this.rgb = rgb;
        this.fovColor = JME3Utilities.convertToColorRGBA((RGBA)rgb);
    }

    public RGBA getColor() {
        return this.rgb;
    }

    public MeshPresentationMode getPresentationMode() {
        return this.meshPresentationMode;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setFOVVisible(boolean visible) {
        Logger.info("Set FOV Visible <" + visible + ")");
        this.fovVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (!AbstractFieldOfViewJME3Object.this.fovVisible && AbstractFieldOfViewJME3Object.this.getAttachmentNode().hasChild((Spatial)AbstractFieldOfViewJME3Object.this.getFovNode())) {
                    AbstractFieldOfViewJME3Object.this.getAttachmentNode().detachChild((Spatial)AbstractFieldOfViewJME3Object.this.getFovNode());
                } else if (AbstractFieldOfViewJME3Object.this.fovVisible && !AbstractFieldOfViewJME3Object.this.getAttachmentNode().hasChild((Spatial)AbstractFieldOfViewJME3Object.this.getFovNode())) {
                    AbstractFieldOfViewJME3Object.this.getAttachmentNode().attachChild((Spatial)AbstractFieldOfViewJME3Object.this.getFovNode());
                }
                return null;
            }
        });
    }

    public boolean isFOVVisible() {
        return this.fovVisible;
    }

    public boolean isShowProjection() {
        return this.showProjection;
    }

    public boolean isShowOutlineOnly() {
        return this.showOutlineOnly;
    }

    public void setProjectionColor(final RGB color) {
        this.projectionColor = color;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                AbstractFieldOfViewJME3Object.this.getAbstractFieldOfViewImageProjectorControl().setProjectionColor(color);
                return null;
            }
        });
    }

    public RGB getProjectionColor() {
        return this.projectionColor;
    }

    public abstract AbstractFieldOfViewImageProjectorControl<R> getAbstractFieldOfViewImageProjectorControl();

    protected Node getFovNode() {
        if (this.fovNode == null) {
            String name = null;
            name = this.getTopologyNode() != null && ((FieldOfView)this.getTopologyNode()).getNodeId() != null ? ((FieldOfView)this.getTopologyNode()).getNodeId() : ((Object)((Object)this)).getClass().getSimpleName();
            name = String.valueOf(name) + "_fov";
            this.fovNode = new Node(name);
            this.getAttachmentNode().attachChild((Spatial)this.fovNode);
        }
        return this.fovNode;
    }
}

