/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.composites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SystemElementListComposite<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject extends SystemElement>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemObject> {
    protected static final int NAME_COL_MIN_WIDTH = 250;
    protected static final Color INVALID_COLOR = new Color((Device)Display.getDefault(), 255, 128, 0);
    protected ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    protected AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);

    public SystemElementListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    public void refresh() {
        try {
            this.getViewer().refresh(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setRootEObject(RootEObject rootEObject) {
        super.setRootEObject(rootEObject);
    }

    protected void createButtons(Composite parent, int style) {
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)250);
        nameColumn.getColumn().setText("Name");
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((SystemElement)element).getName() == null ? "<unnamed>" : ((SystemElement)element).getName();
            }

            public String getToolTipText(Object element) {
                if (element instanceof SystemElement) {
                    return ((SystemElement)element).getDescription();
                }
                return null;
            }

            public Image getImage(Object element) {
                return SystemElementListComposite.this.labelProvider.getImage(element);
            }

            public Color getBackground(Object element) {
                return SystemElementListComposite.this.getBackgroundColor((SystemElement)element);
            }
        });
        TreeViewerColumn descriptionColumn = new TreeViewerColumn(viewer, 0);
        descriptionColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)250);
        descriptionColumn.getColumn().setText("Description");
        descriptionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SystemElement) {
                    return ((SystemElement)element).getDescription();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof SystemElement) {
                    return ((SystemElement)element).getDescription();
                }
                return null;
            }

            public Image getImage(Object element) {
                return null;
            }

            public Color getBackground(Object element) {
                return SystemElementListComposite.this.getBackgroundColor((SystemElement)element);
            }
        });
    }

    protected Collection<SystemElement> filter(Collection<SystemElement> inputs) {
        return new ArrayList<SystemElement>(inputs);
    }

    protected SortedSet<SystemElement> sort(Collection<SystemElement> inputs) {
        TreeSet<SystemElement> sortedSet = new TreeSet<SystemElement>(new Comparator<SystemElement>(){

            @Override
            public int compare(SystemElement o1, SystemElement o2) {
                if (o1.getName() != null && o2.getName() != null) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o1.hashCode() - o2.hashCode();
            }
        });
        sortedSet.addAll(inputs);
        return sortedSet;
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return SystemElementListComposite.this.getEStructuralFeature();
            }

            public Object[] getElements(Object object) {
                EStructuralFeature feature;
                ArrayList<SystemElement> resultList = new ArrayList<SystemElement>();
                if (object != null && (feature = this.getEStructuralFeature()) != null && object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    Object eGetObject = eObject.eGet(feature);
                    if (eGetObject instanceof EList) {
                        EList featureObjectsList = (EList)eGetObject;
                        for (Object element : featureObjectsList) {
                            if (!(element instanceof SystemElement) || resultList.contains(element)) continue;
                            resultList.add((SystemElement)element);
                        }
                    } else {
                        resultList.add((SystemElement)eGetObject);
                    }
                }
                SortedSet<SystemElement> sorted = SystemElementListComposite.this.sort(SystemElementListComposite.this.filter(resultList));
                return sorted.toArray();
            }
        };
    }

    protected Color getBackgroundColor(ItemObject element) {
        Color color = null;
        if (!element.isPowerStateValid()) {
            color = INVALID_COLOR;
        }
        return color;
    }
}

