/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.composites;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.PowerBus;
import org.eclipse.apogy.addons.powersystems.PowerSwitch;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.SystemElementProvider;
import org.eclipse.apogy.addons.powersystems.ui.composites.PowerSwitchesListComposite;
import org.eclipse.apogy.addons.powersystems.ui.wizards.LoadSheddingSwitchesWizard;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class LoadSheddingSwitchesComposite<RootEObject extends EObject>
extends PowerSwitchesListComposite<RootEObject, SystemElementProvider> {
    public LoadSheddingSwitchesComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    @Override
    protected void createButtons(Composite parent, int style) {
        super.createButtons(parent, style);
        this.createSeparator(parent, style);
        this.createUpButton(parent, style);
        this.createDownButton(parent, style);
        this.createSeparator(parent, style);
        this.createAddButton(parent, style).setEnabled(true);
        this.createRemoveButton(parent, style);
    }

    protected Button createAddButton(Composite parent, int style) {
        Button btnAdd = LoadSheddingSwitchesComposite.createButton((Composite)parent, (int)0, (String)"Add...", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doAdd();
            this.refreshViewer();
        }));
        this.createAddButtonBindings(btnAdd);
        return btnAdd;
    }

    protected void createAddButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> !this.getAvailablPowerSwitches((SystemElementProvider)this.getResolvedEObject()).isEmpty());
    }

    protected void doAdd() {
        LoadSheddingSwitchesWizard wizard = new LoadSheddingSwitchesWizard((SystemElementProvider)this.getResolvedEObject());
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.open();
    }

    protected Button createRemoveButton(Composite parent, int style) {
        Button btnRemove = LoadSheddingSwitchesComposite.createButton((Composite)parent, (int)0, (String)"Remove", e -> {
            List elements = this.getViewer().getStructuredSelection().toList();
            BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
                this.doRemove(elements);
                this.refreshViewer();
            });
        });
        this.createRemoveButtonBindings(btnRemove);
        return btnRemove;
    }

    protected void createRemoveButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> !this.getViewer().getStructuredSelection().isEmpty());
    }

    protected void doRemove(List<PowerSwitch> items) {
        PowerBus powerBus = this.getPowerBus((SystemElementProvider)this.getResolvedEObject());
        if (powerBus != null) {
            for (PowerSwitch powerSwitch : items) {
                try {
                    ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)powerBus, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__LOAD_SHEDDING_SWITCHES, (Object)powerSwitch, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected List<PowerSwitch> getAvailablPowerSwitches(SystemElementProvider systemElementProvider) {
        ArrayList<PowerSwitch> result = new ArrayList<PowerSwitch>();
        PowerBus powerBus = this.getPowerBus((SystemElementProvider)this.getResolvedEObject());
        if (powerBus != null) {
            for (SystemElement systemElement : systemElementProvider.getProvidedElements()) {
                if (!(systemElement instanceof PowerSwitch)) continue;
                PowerSwitch powerSwitch = (PowerSwitch)systemElement;
                if (powerBus.getLoadSheddingSwitches().contains((Object)systemElement)) continue;
                result.add(powerSwitch);
            }
        }
        return result;
    }

    protected PowerBus getPowerBus(SystemElementProvider systemElementProvider) {
        PowerBus powerBus = null;
        if (systemElementProvider != null) {
            EList elements = systemElementProvider.getProvidedElements();
            Iterator it = elements.iterator();
            while (it.hasNext() && powerBus == null) {
                SystemElement element = (SystemElement)it.next();
                if (!(element instanceof PowerBus)) continue;
                powerBus = (PowerBus)element;
            }
        }
        return powerBus;
    }
}

