/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.impl;

import java.util.List;
import org.eclipse.apogy.addons.SimpleTool;
import org.eclipse.apogy.addons.SimpleToolList;
import org.eclipse.apogy.addons.impl.SimpleToolListImpl;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleToolListCustomImpl
extends SimpleToolListImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SimpleToolListImpl.class);
    private Adapter adapter = null;
    private Adapter variableAdapter = null;

    protected SimpleToolListCustomImpl() {
        this.eAdapters().add((Object)this.getAdapter());
        ApogyCoreInvocatorFacade.INSTANCE.eAdapters().add((Object)this.getVariableAdapter());
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void notifyChanged(Notification msg) {
                    if (!(msg.getNotifier() instanceof SimpleToolList)) return;
                    int featureId = msg.getFeatureID(SimpleToolList.class);
                    switch (featureId) {
                        case 1: {
                            switch (msg.getEventType()) {
                                case 3: {
                                    if (!(msg.getNewValue() instanceof SimpleTool)) return;
                                    SimpleTool simpleTool = (SimpleTool)msg.getNewValue();
                                    try {
                                        simpleTool.initialise();
                                    }
                                    catch (Exception e) {
                                        Logger.error("Exception occured during SimpleTool initialise().", (Throwable)e);
                                    }
                                    return;
                                }
                                case 5: {
                                    if (msg.getNewValue() instanceof List) {
                                        List tools = (List)msg.getNewValue();
                                        for (SimpleTool simpleTool : tools) {
                                            try {
                                                simpleTool.initialise();
                                            }
                                            catch (Exception e) {
                                                Logger.error("Exception occured during SimpleTool initialise().", (Throwable)e);
                                            }
                                        }
                                    }
                                }
                                case 4: {
                                    if (!(msg.getOldValue() instanceof SimpleTool)) return;
                                    SimpleTool simpleTool = (SimpleTool)msg.getOldValue();
                                    try {
                                        simpleTool.dispose();
                                    }
                                    catch (Exception e) {
                                        Logger.error("Exception occured during SimpleTool dispose().", (Throwable)e);
                                    }
                                    return;
                                }
                                case 6: {
                                    if (!(msg.getOldValue() instanceof List)) return;
                                    List tools = (List)msg.getOldValue();
                                    for (SimpleTool simpleTool : tools) {
                                        try {
                                            simpleTool.dispose();
                                        }
                                        catch (Exception e) {
                                            Logger.error("Exception occured during SimpleTool dispose().", (Throwable)e);
                                        }
                                    }
                                }
                            }
                            return;
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    private Adapter getVariableAdapter() {
        if (this.variableAdapter == null) {
            this.variableAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyCoreInvocatorFacade) {
                        int featureID = msg.getFeatureID(ApogyCoreInvocatorFacade.class);
                        switch (featureID) {
                            case 0: {
                                for (SimpleTool tool : SimpleToolListCustomImpl.this.getSimpleTools()) {
                                    try {
                                        tool.variablesInstantiated();
                                    }
                                    catch (Throwable t) {
                                        Logger.error(t.getMessage(), t);
                                    }
                                }
                                break;
                            }
                            case 1: {
                                for (SimpleTool tool : SimpleToolListCustomImpl.this.getSimpleTools()) {
                                    try {
                                        tool.variablesCleared();
                                    }
                                    catch (Throwable t) {
                                        Logger.error(t.getMessage(), t);
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.variableAdapter;
    }
}

