/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.impl.AbstractTwoPoints3DToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.util.NodeRelativePoseListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTwoPoints3DToolCustomImpl
extends AbstractTwoPoints3DToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractTwoPoints3DToolImpl.class);
    private NodeRelativePoseListener nodeRelativePoseListener;

    @Override
    public void setFromRelativePosition(Tuple3d newFromRelativePosition) {
        super.setFromRelativePosition(newFromRelativePosition);
        this.updateFromAbsolutePosition();
        this.updateDistance();
    }

    @Override
    public void setFromNode(Node newFromNode) {
        super.setFromNode(newFromNode);
        this.updateFromAbsolutePosition();
        this.updateDistance();
        this.getNodeRelativePoseListener().setFromNode(newFromNode);
    }

    @Override
    public void setToRelativePosition(Tuple3d newToRelativePosition) {
        super.setToRelativePosition(newToRelativePosition);
        this.updateToAbsolutePosition();
        this.updateDistance();
    }

    @Override
    public void setToNode(Node newToNode) {
        super.setToNode(newToNode);
        this.updateToAbsolutePosition();
        this.updateDistance();
        this.getNodeRelativePoseListener().setToNode(newToNode);
    }

    @Override
    public abstract void pointsRelativePoseChanged(Matrix4d var1);

    @Override
    public void dispose() {
        if (this.nodeRelativePoseListener != null) {
            this.nodeRelativePoseListener.dispose();
            this.nodeRelativePoseListener = null;
        }
        super.dispose();
    }

    @Override
    public void setRootNode(Node newRootNode) {
        super.setRootNode(newRootNode);
        if (this.getToNodeNodePath() != null && !this.isToNodeLock()) {
            Node to = ApogyCommonTopologyFacade.INSTANCE.resolveNode(this.getRootNode(), this.getToNodeNodePath());
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_NODE, (Object)to);
        }
        if (this.getFromNodeNodePath() != null && !this.isFromNodeLock()) {
            Node from = ApogyCommonTopologyFacade.INSTANCE.resolveNode(this.getRootNode(), this.getFromNodeNodePath());
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_NODE, (Object)from);
        }
    }

    @Override
    public void variablesInstantiated() {
        if (this.getToNodeNodePath() != null && !this.isToNodeLock()) {
            Node to = ApogyCommonTopologyFacade.INSTANCE.resolveNode(this.getRootNode(), this.getToNodeNodePath());
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_NODE, (Object)to);
        }
        if (this.getFromNodeNodePath() != null && !this.isFromNodeLock()) {
            Node from = ApogyCommonTopologyFacade.INSTANCE.resolveNode(this.getRootNode(), this.getFromNodeNodePath());
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_NODE, (Object)from);
        }
    }

    @Override
    public void variablesCleared() {
    }

    protected void updateFromAbsolutePosition() {
        if (this.getFromNode() != null) {
            Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(this.getFromNode());
            Point3d from = new Point3d();
            if (this.getFromRelativePosition() != null) {
                from = new Point3d(this.getFromRelativePosition().asTuple3d());
            }
            m.transform(from);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_ABSOLUTE_POSITION, (Object)ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)from));
        }
    }

    protected void updateToAbsolutePosition() {
        if (this.getToNode() != null) {
            Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(this.getToNode());
            Point3d to = new Point3d();
            if (this.getToRelativePosition() != null) {
                to = new Point3d(this.getToRelativePosition().asTuple3d());
            }
            m.transform(to);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_ABSOLUTE_POSITION, (Object)ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)to));
        }
    }

    protected void forceToAndFromReload() {
        if (this.getRootNode() != null) {
            if (this.getFromNode() == null && this.getFromNodeNodePath() != null) {
                try {
                    Node from = ApogyCommonTopologyFacade.INSTANCE.resolveNode(this.getRootNode(), this.getFromNodeNodePath());
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_NODE, (Object)from);
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.getToNode() == null && this.getToNodeNodePath() != null) {
                try {
                    Node to = ApogyCommonTopologyFacade.INSTANCE.resolveNode(this.getRootNode(), this.getToNodeNodePath());
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_NODE, (Object)to);
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void updateDistance() {
        double distance = 0.0;
        if (this.getFromAbsolutePosition() != null && this.getToAbsolutePosition() != null) {
            Point3d from = new Point3d(this.getFromAbsolutePosition().asTuple3d());
            Point3d to = new Point3d(this.getToAbsolutePosition().asTuple3d());
            distance = to.distance(from);
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__DISTANCE, (Object)distance);
    }

    protected NodeRelativePoseListener getNodeRelativePoseListener() {
        if (this.nodeRelativePoseListener == null) {
            this.nodeRelativePoseListener = new NodeRelativePoseListener(){

                public void relativePoseChanged(Matrix4d newPose) {
                    if (!AbstractTwoPoints3DToolCustomImpl.this.isDisposed()) {
                        AbstractTwoPoints3DToolCustomImpl.this.updateFromAbsolutePosition();
                        AbstractTwoPoints3DToolCustomImpl.this.updateToAbsolutePosition();
                        AbstractTwoPoints3DToolCustomImpl.this.updateDistance();
                        AbstractTwoPoints3DToolCustomImpl.this.pointsRelativePoseChanged(newPose);
                    }
                }
            };
        }
        return this.nodeRelativePoseListener;
    }
}

