/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Axis implements Enumerator
{
    XAXIS(0, "X_AXIS", "X_AXIS"),
    YAXIS(1, "Y_AXIS", "Y_AXIS"),
    ZAXIS(2, "Z_AXIS", "Z_AXIS"),
    MINUS_XAXIS(3, "MINUS_X_AXIS", "MINUS_X_AXIS"),
    MINUS_YAXIS(4, "MINUS_Y_AXIS", "MINUS_Y_AXIS"),
    MINUS_ZAXIS(5, "MINUS_Z_AXIS", "MINUS_Z_AXIS");

    public static final int XAXIS_VALUE = 0;
    public static final int YAXIS_VALUE = 1;
    public static final int ZAXIS_VALUE = 2;
    public static final int MINUS_XAXIS_VALUE = 3;
    public static final int MINUS_YAXIS_VALUE = 4;
    public static final int MINUS_ZAXIS_VALUE = 5;
    private static final Axis[] VALUES_ARRAY;
    public static final List<Axis> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Axis[]{XAXIS, YAXIS, ZAXIS, MINUS_XAXIS, MINUS_YAXIS, MINUS_ZAXIS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Axis get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Axis result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Axis getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Axis result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Axis get(int value) {
        switch (value) {
            case 0: {
                return XAXIS;
            }
            case 1: {
                return YAXIS;
            }
            case 2: {
                return ZAXIS;
            }
            case 3: {
                return MINUS_XAXIS;
            }
            case 4: {
                return MINUS_YAXIS;
            }
            case 5: {
                return MINUS_ZAXIS;
            }
        }
        return null;
    }

    private Axis(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

