/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.wizards;

import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.AbstractFeatureTreeNode;
import org.eclipse.apogy.common.emf.AbstractRootNode;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.TreeFeatureNode;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class TreeFeatureNodeWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.emf.ui.wizards.TreeFeatureNodeWizardPage";
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final TreeFeatureNode treeFeatureNode;
    private final AbstractFeatureTreeNode parent;
    private Tree tree;
    private TreeViewer treeViewer;
    private Text txtFeatureName;
    private Text txtFeatureDescription;
    private Text txtFeatureType;

    public TreeFeatureNodeWizardPage(TreeFeatureNode treeFeatureNode, AbstractFeatureTreeNode parent) {
        super(WIZARD_PAGE_ID);
        this.setTitle("New Feature");
        this.setDescription("Select the feature.");
        this.treeFeatureNode = treeFeatureNode;
        this.parent = parent;
    }

    public void createControl(Composite arg0) {
        Composite container = new Composite(arg0, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        if (!this.hasSubNodes(this.parent)) {
            Label lblMessage = new Label(container, 0);
            GridData gd_lblMessage = new GridData(4, 128, true, false);
            lblMessage.setLayoutData((Object)gd_lblMessage);
            lblMessage.setText("There are no sub-feature available !");
            this.setErrorMessage("There are no sub-feature available !");
            this.setPageComplete(false);
        } else {
            Composite leftComposite = new Composite(container, 0);
            GridData gd_leftComposite = new GridData(4, 4, true, true);
            leftComposite.setLayoutData((Object)gd_leftComposite);
            leftComposite.setLayout((Layout)new GridLayout(1, false));
            Label blbFeatures = new Label(leftComposite, 0);
            blbFeatures.setText("Available Features");
            this.treeViewer = new TreeViewer(leftComposite, 68354);
            this.tree = this.treeViewer.getTree();
            GridData gd_tree = new GridData(4, 4, true, true, 1, 3);
            gd_tree.widthHint = 200;
            gd_tree.minimumWidth = 200;
            this.tree.setLayoutData((Object)gd_tree);
            this.tree.setLinesVisible(true);
            this.treeViewer.setContentProvider((IContentProvider)new CustomContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
            this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (TreeFeatureNodeWizardPage.this.treeViewer.getSelection() instanceof StructuredSelection) {
                        StructuredSelection structuredSelection = (StructuredSelection)TreeFeatureNodeWizardPage.this.treeViewer.getSelection();
                        EStructuralFeature eStructuralFeature = (EStructuralFeature)structuredSelection.getFirstElement();
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)TreeFeatureNodeWizardPage.this.treeFeatureNode, (EStructuralFeature)ApogyCommonEMFPackage.Literals.ABSTRACT_FEATURE_SPECIFIER__STRUCTURAL_FEATURE, (Object)eStructuralFeature, true);
                        TreeFeatureNodeWizardPage.this.txtFeatureName.setText(eStructuralFeature.getName());
                        TreeFeatureNodeWizardPage.this.txtFeatureDescription.setText(ApogyCommonEMFFacade.INSTANCE.getFullDescription((ETypedElement)eStructuralFeature));
                        TreeFeatureNodeWizardPage.this.txtFeatureType.setText(eStructuralFeature.getEType().getInstanceTypeName());
                        TreeFeatureNodeWizardPage.this.txtFeatureType.setToolTipText(eStructuralFeature.getEType().getInstanceTypeName());
                    }
                }
            });
            this.treeViewer.setInput((Object)this.parent);
            Composite rightComposite = new Composite(container, 0);
            GridData gd_rightComposite = new GridData(4, 4, true, false);
            rightComposite.setLayoutData((Object)gd_rightComposite);
            rightComposite.setLayout((Layout)new GridLayout(2, false));
            Label lblFeatureDetails = new Label(rightComposite, 0);
            lblFeatureDetails.setText("Feature Details");
            GridData gd_lblFeatureDetails = new GridData(16384, 0x1000000, false, false, 2, 1);
            lblFeatureDetails.setLayoutData((Object)gd_lblFeatureDetails);
            Label lblFeatureName = new Label(rightComposite, 0);
            lblFeatureName.setText("Name : ");
            GridData gd_lblFeatureName = new GridData(16384, 0x1000000, false, false, 1, 1);
            lblFeatureName.setLayoutData((Object)gd_lblFeatureName);
            this.txtFeatureName = new Text(rightComposite, 2048);
            this.txtFeatureName.setEditable(false);
            this.txtFeatureName.setText("");
            GridData gd_txtFeatureName = new GridData(4, 0x1000000, true, false, 1, 1);
            this.txtFeatureName.setLayoutData((Object)gd_txtFeatureName);
            Label lblFeatureDescription = new Label(rightComposite, 0);
            lblFeatureDescription.setText("Description : ");
            GridData gd_lblFeatureDescription = new GridData(16384, 128, false, false, 1, 1);
            lblFeatureDescription.setLayoutData((Object)gd_lblFeatureDescription);
            this.txtFeatureDescription = new Text(rightComposite, 2818);
            this.txtFeatureDescription.setEditable(false);
            this.txtFeatureDescription.setText("");
            GridData gd_txtFeatureDescription = new GridData(4, 128, true, false, 1, 1);
            gd_txtFeatureDescription.minimumHeight = 100;
            gd_txtFeatureDescription.heightHint = 100;
            this.txtFeatureDescription.setLayoutData((Object)gd_txtFeatureDescription);
            Label lblFeatureType = new Label(rightComposite, 0);
            lblFeatureType.setText("Type : ");
            GridData gd_lblFeatureType = new GridData(16384, 0x1000000, false, false, 1, 1);
            lblFeatureType.setLayoutData((Object)gd_lblFeatureType);
            this.txtFeatureType = new Text(rightComposite, 2048);
            this.txtFeatureType.setEditable(false);
            this.txtFeatureType.setText("");
            GridData gd_txtFeatureType = new GridData(4, 0x1000000, true, false, 1, 1);
            this.txtFeatureType.setLayoutData((Object)gd_txtFeatureType);
        }
        this.setControl((Control)container);
    }

    private boolean hasSubNodes(AbstractFeatureTreeNode parent) {
        AbstractFeatureSpecifier abstractFeatureSpecifier;
        if (parent instanceof AbstractRootNode) {
            AbstractRootNode abstractRootNode = (AbstractRootNode)parent;
            if (abstractRootNode.getSourceClass() == null) {
                return false;
            }
            return abstractRootNode.getSourceClass().getEAllStructuralFeatures().size() > 0;
        }
        if (parent instanceof AbstractFeatureSpecifier && (abstractFeatureSpecifier = (AbstractFeatureSpecifier)parent).getStructuralFeature() != null) {
            EStructuralFeature eStructuralFeature = abstractFeatureSpecifier.getStructuralFeature();
            if (eStructuralFeature.getEType() instanceof EClass) {
                EClass eClass = (EClass)eStructuralFeature.getEType();
                return eClass.getEAllStructuralFeatures().size() > 0;
            }
            return false;
        }
        return false;
    }

    private class CustomContentProvider
    implements ITreeContentProvider {
        private CustomContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof AbstractRootNode) {
                AbstractRootNode abstractRootNode = (AbstractRootNode)inputElement;
                if (abstractRootNode.getSourceClass() != null) {
                    return abstractRootNode.getSourceClass().getEAllStructuralFeatures().toArray();
                }
                return null;
            }
            if (inputElement instanceof AbstractFeatureSpecifier) {
                AbstractFeatureSpecifier abstractFeatureSpecifier = (AbstractFeatureSpecifier)inputElement;
                if (abstractFeatureSpecifier.getStructuralFeature() != null) {
                    EStructuralFeature eStructuralFeature = abstractFeatureSpecifier.getStructuralFeature();
                    if (eStructuralFeature.getEType() instanceof EClass) {
                        EClass eClass = (EClass)eStructuralFeature.getEType();
                        return eClass.getEAllStructuralFeatures().toArray();
                    }
                    return null;
                }
                return null;
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

