/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.wizards;

import java.util.Date;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.DateAndTimeComposite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class TimeIntervalWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.emf.ui.wizards.TimeIntervalWizardPage";
    protected TimeInterval timeInterval;
    protected DateAndTimeComposite fromDateComposite;
    protected DateAndTimeComposite toDateComposite;

    public TimeIntervalWizardPage(TimeInterval timeInterval) {
        super(WIZARD_PAGE_ID);
        this.timeInterval = timeInterval;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        this.setControl((Control)container);
        Group fromDateGroup = new Group(container, 2048);
        fromDateGroup.setLayout((Layout)new GridLayout(1, true));
        fromDateGroup.setText("From Date");
        this.fromDateComposite = new DateAndTimeComposite((Composite)fromDateGroup, 0){

            @Override
            protected void newDateSelected(Date date) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)TimeIntervalWizardPage.this.timeInterval, (EStructuralFeature)ApogyCommonEMFPackage.Literals.TIME_INTERVAL__FROM_DATE, (Object)date, true);
                TimeIntervalWizardPage.this.validate();
            }
        };
        this.fromDateComposite.setLayoutData(new GridData(4, 128, true, false, 1, 1));
        if (this.timeInterval.getFromDate() != null) {
            this.fromDateComposite.setSelectedDate(this.timeInterval.getFromDate());
        }
        Group toDateGroup = new Group(container, 2048);
        toDateGroup.setLayout((Layout)new GridLayout(1, true));
        toDateGroup.setText("To Date");
        this.toDateComposite = new DateAndTimeComposite((Composite)toDateGroup, 0){

            @Override
            protected void newDateSelected(Date date) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)TimeIntervalWizardPage.this.timeInterval, (EStructuralFeature)ApogyCommonEMFPackage.Literals.TIME_INTERVAL__TO_DATE, (Object)date, true);
                TimeIntervalWizardPage.this.validate();
            }
        };
        this.toDateComposite.setLayoutData(new GridData(4, 128, true, false, 1, 1));
        if (this.timeInterval.getToDate() != null) {
            this.toDateComposite.setSelectedDate(this.timeInterval.getToDate());
        }
        this.validate();
    }

    protected void validate() {
        String errorMessage = null;
        if (this.timeInterval.getFromDate() == null) {
            errorMessage = "From date is not set !";
        }
        if (this.timeInterval.getToDate() == null) {
            errorMessage = "To date is not set !";
        }
        if (this.timeInterval.getFromDate() != null && this.timeInterval.getToDate() != null && this.timeInterval.getFromDate().getTime() > this.timeInterval.getToDate().getTime()) {
            errorMessage = "To Date is before End Date!";
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

