/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.wizards;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.Constants;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractWizardPage<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject>
extends WizardPage {
    private RootEObject rootEObject;
    private FeaturePath featurePath;
    private EStructuralFeature eStructuralFeature;
    private ResolvedEObject resolvedObject;
    private Adapter adapter;

    public AbstractWizardPage(String id, RootEObject rootEObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(id);
        this.featurePath = featurePath;
        this.eStructuralFeature = eStructuralFeature;
        this.setRootEObject(rootEObject);
        this.configurePage();
    }

    protected void configurePage() {
        this.setDescription("Set the object properties");
        this.setImageDescriptor(Constants.APOGY_WIZARD_IMAGE_DESCRIPTOR);
    }

    public abstract void createControl(Composite var1);

    protected void validate() {
    }

    public RootEObject getRootEObject() {
        return this.rootEObject;
    }

    public void setRootEObject(RootEObject rootEObject) {
        this.rootEObject = rootEObject;
        if (this.resolvedObject != null) {
            this.resolvedObject.eAdapters().remove((Object)this.getAdapter());
        }
        this.resolvedObject = ApogyCommonEMFFacade.INSTANCE.resolveOwner(rootEObject, this.getFeaturePath());
        if (this.resolvedObject != null) {
            this.resolvedObject.eAdapters().add((Object)this.getAdapter());
        }
        this.internalRootEObjectChanged(rootEObject);
        this.rootEObjectChanged(rootEObject);
        this.validate();
    }

    protected void internalRootEObjectChanged(RootEObject rootEObject) {
    }

    protected void rootEObjectChanged(RootEObject rootEObject) {
    }

    public FeaturePath getFeaturePath() {
        return this.featurePath;
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    public ResolvedEObject getResolvedEObject() {
        return this.resolvedObject;
    }

    public void dispose() {
        if (this.resolvedObject != null) {
            this.resolvedObject.eAdapters().remove((Object)this.getAdapter());
        }
        super.dispose();
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    AbstractWizardPage.this.validate();
                }
            };
        }
        return this.adapter;
    }
}

