/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ui.composites.AbstractECollectionComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.AbstractWizardPage;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractECollectionWizardPage<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject extends EObject>
extends AbstractWizardPage<RootEObject, ResolvedEObject, ItemObject> {
    private AbstractECollectionComposite<RootEObject, ResolvedEObject, ItemObject> composite;

    public AbstractECollectionWizardPage(String id, RootEObject rootEObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(id, rootEObject, featurePath, eStructuralFeature);
    }

    @Override
    protected void configurePage() {
        super.configurePage();
        this.setTitle("Select an element");
        this.setDescription("Select an element from the list.");
    }

    @Override
    public void createControl(Composite parent) {
        this.composite = this.createContentComposite(parent, 0);
        this.composite.addSelectionChangedListener(e -> {
            this.selectionChanged(this.getCurrentSelection());
            this.validate();
        });
        this.setControl((Control)this.composite);
        this.composite.setRootEObject(this.getRootEObject());
        this.validate();
    }

    @Override
    public void internalRootEObjectChanged(RootEObject rootEObject) {
        if (this.composite != null) {
            this.composite.setRootEObject(this.getRootEObject());
        }
    }

    protected abstract AbstractECollectionComposite<RootEObject, ResolvedEObject, ItemObject> createContentComposite(Composite var1, int var2);

    protected void selectionChanged(IStructuredSelection currentSelection) {
    }

    protected List<ItemObject> getSelectedItemObjects() {
        ArrayList list = new ArrayList();
        if (this.getCurrentSelection() != null) {
            list.addAll(this.getCurrentSelection().toList());
        }
        return list;
    }

    public final IStructuredSelection getCurrentSelection() {
        return this.composite == null ? null : this.composite.getCurrentSelection();
    }

    @Override
    protected void validate() {
        String errorMessage = this.getCurrentSelection() == null || this.getCurrentSelection().isEmpty() ? "An element must be selected" : null;
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }
}

