/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.composites;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class EObjectCompareComposite
extends Composite {
    public static final String NO_DELTA_STRING = "";
    public static final String RIGHT_FACING_ARROW_STRING = "\u2192";
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private List<EStructuralFeature> features;
    protected TreeViewer treeViewer;
    private EObject oldEObject;
    private EObject newEObject;

    public EObjectCompareComposite(Composite parent, int style, List<EStructuralFeature> features) {
        super(parent, style);
        this.features = new ArrayList<EStructuralFeature>(features);
        this.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        Tree table = this.treeViewer.getTree();
        GridData table_gd = new GridData(4, 4, true, true, 1, 1);
        table_gd.minimumHeight = 400;
        table_gd.heightHint = 400;
        table_gd.grabExcessVerticalSpace = false;
        table.setLayoutData((Object)table_gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.populateColumns(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new CustomAdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.treeViewer.setInput(features);
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.treeViewer.refresh();
        this.treeViewer.getTree().layout();
    }

    public EObject getOldEObject() {
        return this.oldEObject;
    }

    public void setOldEObject(EObject oldEObject) {
        this.oldEObject = oldEObject;
        this.treeViewer.setInput(this.features);
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    public EObject getNewEObject() {
        return this.newEObject;
    }

    public void setNewEObject(EObject newEObject) {
        this.newEObject = newEObject;
        this.treeViewer.setInput(this.features);
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    protected void populateColumns(TreeViewer treeViewer) {
        final TreeViewerColumn featureTableViewerColumn = new TreeViewerColumn(treeViewer, 0);
        featureTableViewerColumn.getColumn().setText("Feature");
        featureTableViewerColumn.getColumn().setAlignment(0x1000000);
        featureTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EStructuralFeature) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)element;
                    Unit displayedUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)eStructuralFeature);
                    String text = eStructuralFeature.getName();
                    if (displayedUnits != null) {
                        text = String.valueOf(text) + " (" + displayedUnits.toString() + ")";
                    }
                    return text;
                }
                return "?";
            }
        });
        featureTableViewerColumn.getColumn().setWidth(100);
        featureTableViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (featureTableViewerColumn.getColumn().getWidth() < 100) {
                    featureTableViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        final TreeViewerColumn previousValueTableViewerColumn = new TreeViewerColumn(treeViewer, 0);
        previousValueTableViewerColumn.getColumn().setText("Old Value");
        previousValueTableViewerColumn.getColumn().setAlignment(0x1000000);
        previousValueTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EStructuralFeature) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)element;
                    return EObjectCompareComposite.this.getValue(EObjectCompareComposite.this.oldEObject, eStructuralFeature);
                }
                return "?";
            }
        });
        previousValueTableViewerColumn.getColumn().setWidth(100);
        previousValueTableViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (previousValueTableViewerColumn.getColumn().getWidth() < 100) {
                    previousValueTableViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        final TreeViewerColumn newValueTableViewerColumn = new TreeViewerColumn(treeViewer, 0);
        newValueTableViewerColumn.getColumn().setText("New Value");
        newValueTableViewerColumn.getColumn().setAlignment(0x1000000);
        newValueTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EStructuralFeature) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)element;
                    return EObjectCompareComposite.this.getValue(EObjectCompareComposite.this.newEObject, eStructuralFeature);
                }
                return "?";
            }
        });
        newValueTableViewerColumn.getColumn().setWidth(100);
        newValueTableViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (newValueTableViewerColumn.getColumn().getWidth() < 100) {
                    newValueTableViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
        final TreeViewerColumn deltaValueTableViewerColumn = new TreeViewerColumn(treeViewer, 0);
        deltaValueTableViewerColumn.getColumn().setText("Delta");
        deltaValueTableViewerColumn.getColumn().setAlignment(0x1000000);
        deltaValueTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EStructuralFeature) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)element;
                    return EObjectCompareComposite.this.getDeltaValue(EObjectCompareComposite.this.oldEObject, EObjectCompareComposite.this.newEObject, eStructuralFeature);
                }
                return "?";
            }
        });
        deltaValueTableViewerColumn.getColumn().setWidth(100);
        deltaValueTableViewerColumn.getColumn().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent arg0) {
                if (deltaValueTableViewerColumn.getColumn().getWidth() < 100) {
                    deltaValueTableViewerColumn.getColumn().setWidth(100);
                }
            }

            public void controlMoved(ControlEvent arg0) {
            }
        });
    }

    protected String getValue(EObject eObject, EStructuralFeature eStructuralFeature) {
        if (eObject != null) {
            Object value = eObject.eGet(eStructuralFeature);
            if (value != null) {
                if (value instanceof Number) {
                    return ApogyCommonEMFUIFacade.INSTANCE.getDisplayedString((Number)value, (ETypedElement)eStructuralFeature);
                }
                if (value instanceof Date) {
                    return ApogyCommonEMFFacade.INSTANCE.format((Date)value);
                }
                return value.toString();
            }
            return "-";
        }
        return "-";
    }

    protected String getDeltaValue(EObject oldEObject, EObject newEObject, EStructuralFeature eStructuralFeature) {
        if (oldEObject != null && newEObject != null) {
            Object oldValue = oldEObject.eGet(eStructuralFeature);
            Object newValue = newEObject.eGet(eStructuralFeature);
            if (oldValue == null && newValue != null) {
                return "null ->" + this.getValue(newEObject, eStructuralFeature);
            }
            if (oldValue != null && newValue == null) {
                return String.valueOf(this.getValue(oldEObject, eStructuralFeature)) + " " + RIGHT_FACING_ARROW_STRING + " null";
            }
            if (oldValue != null && newValue != null) {
                if (oldValue instanceof Number) {
                    Number oldNumber = (Number)oldValue;
                    Number newNumber = (Number)newValue;
                    if (oldNumber.doubleValue() != newNumber.doubleValue()) {
                        Double difference = newNumber.doubleValue() - oldNumber.doubleValue();
                        Number convertedDifference = ApogyCommonEMFUIFacade.INSTANCE.convertToDisplayUnits((Number)difference, (ETypedElement)eStructuralFeature);
                        return new Double(convertedDifference.doubleValue()).toString();
                    }
                    return NO_DELTA_STRING;
                }
                if (oldValue instanceof Boolean) {
                    Boolean oldBoolean = (Boolean)oldValue;
                    Boolean newBoolean = (Boolean)newValue;
                    if (oldBoolean != newBoolean) {
                        return String.valueOf(oldBoolean.toString()) + " " + RIGHT_FACING_ARROW_STRING + " " + newBoolean.toString();
                    }
                    return NO_DELTA_STRING;
                }
                if (oldValue instanceof String) {
                    String oldString = (String)oldValue;
                    String newString = (String)newValue;
                    if (oldString.compareTo(newString) != 0) {
                        return String.valueOf(oldString) + " -> " + newString;
                    }
                    return NO_DELTA_STRING;
                }
                if (oldValue != newValue) {
                    return String.valueOf(oldValue.toString()) + " " + RIGHT_FACING_ARROW_STRING + " " + newValue.toString();
                }
                return NO_DELTA_STRING;
            }
        }
        return NO_DELTA_STRING;
    }

    public class CustomAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public CustomAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            return EObjectCompareComposite.this.features.toArray();
        }

        public boolean hasChildren(Object object) {
            return false;
        }
    }
}

