/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.android.datamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sequoyah.localization.android.manager.LocalizationFileManagerFactory;
import org.eclipse.sequoyah.localization.android.manager.StringLocalizationFileManager;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileBean;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileFactory;
import org.eclipse.sequoyah.localization.tools.datamodel.StringLocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayItemNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringNode;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidStringLocalizationFile
extends StringLocalizationFile {
    private Document savedXMLDocument = null;
    private Map<String, StringNode> singleEntryToRemove = new HashMap<String, StringNode>();
    private List<StringArrayItemNode> arrayItemsToRemove = new ArrayList<StringArrayItemNode>();
    private Map<String, StringArrayNode> arraysToRemove = new HashMap<String, StringArrayNode>();

    static {
        LocalizationFileFactory.getInstance().addFileType(AndroidStringLocalizationFile.class.getName(), AndroidStringLocalizationFile.class);
        LocalizationFileManagerFactory.getInstance().addManager(AndroidStringLocalizationFile.class.getName(), StringLocalizationFileManager.class);
    }

    public AndroidStringLocalizationFile(LocalizationFileBean localizationFileBean) {
        super(localizationFileBean);
    }

    public Document getSavedXMLDocument() {
        return this.savedXMLDocument;
    }

    public void setSavedXMLDocument(Document document) {
        this.savedXMLDocument = document;
    }

    public void removeStringNode(StringNode stringNode) {
        if (this.containsKey(stringNode.getKey())) {
            this.removeNode(stringNode.getKey());
            this.setDirty(true);
            if (stringNode instanceof StringArrayNode) {
                StringArrayNode stringArrayNode = (StringArrayNode)stringNode;
                this.arraysToRemove.put(stringArrayNode.getKey(), stringArrayNode);
            } else {
                this.singleEntryToRemove.put(stringNode.getKey(), stringNode);
            }
        }
    }

    public StringNode addStringNode(StringNode stringNode) {
        StringNode stringNode2 = super.addStringNode(stringNode);
        if (stringNode instanceof StringArrayNode) {
            StringArrayNode stringArrayNode = (StringArrayNode)stringNode;
            if (this.arraysToRemove.containsKey(stringArrayNode.getKey())) {
                this.arraysToRemove.remove(stringArrayNode.getKey());
            }
        } else if (this.singleEntryToRemove.containsKey(stringNode.getKey())) {
            this.singleEntryToRemove.remove(stringNode.getKey());
        }
        return stringNode2;
    }

    public void removeStringArrayItemNode(StringArrayItemNode stringArrayItemNode) {
        super.removeStringArrayItemNode(stringArrayItemNode);
        if (stringArrayItemNode.getParent().getValues().size() == 0) {
            this.arraysToRemove.put(stringArrayItemNode.getParent().getKey(), stringArrayItemNode.getParent());
            this.removeNode(stringArrayItemNode.getParent().getKey());
        } else {
            this.arrayItemsToRemove.add(stringArrayItemNode);
        }
    }

    public StringNode addStringArrayItemNode(StringArrayItemNode stringArrayItemNode) {
        StringNode stringNode = super.addStringArrayItemNode(stringArrayItemNode);
        if (stringArrayItemNode.getParent() != null && stringArrayItemNode.getParent().getValues().size() == 0) {
            this.arraysToRemove.remove(stringArrayItemNode.getParent().getKey());
            this.addStringNode((StringNode)stringArrayItemNode.getParent());
        } else {
            Iterator<StringArrayItemNode> iterator = this.arrayItemsToRemove.iterator();
            while (iterator.hasNext()) {
                StringArrayItemNode stringArrayItemNode2 = iterator.next();
                if (!stringArrayItemNode.getParent().equals((Object)stringArrayItemNode2.getParent()) || stringArrayItemNode.getPosition() != stringArrayItemNode2.getPosition()) continue;
                iterator.remove();
            }
        }
        return stringNode;
    }

    public Map<String, StringNode> getSingleEntryToRemove() {
        return this.singleEntryToRemove;
    }

    public List<StringArrayItemNode> getArrayItemsToRemove() {
        return this.arrayItemsToRemove;
    }

    public Map<String, StringArrayNode> getArrayEntryToRemove() {
        return this.arraysToRemove;
    }
}

