/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote.ui.wireless;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.remote.RemoteDevicePlugin;
import org.eclipse.andmore.android.remote.i18n.RemoteDeviceNLS;
import org.eclipse.andmore.android.remote.ui.wireless.WirelessDeviceWizardPage;
import org.eclipse.andmore.android.remote.ui.wireless.runnables.SwitchFromUSBAndConnectToWirelessRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class WirelessWizard
extends Wizard {
    private final String WIRELESS_WIZARD_IMAGE_PATH = "icons/wireless_wizard-icon-64x64.png";
    WirelessDeviceWizardPage informationPage;
    private ISerialNumbered instance;
    private String host;
    private IProgressMonitor monitor;

    public WirelessWizard() {
        super.setDefaultPageImageDescriptor(RemoteDevicePlugin.getImageDescriptor("icons/wireless_wizard-icon-64x64.png"));
        this.setWindowTitle(RemoteDeviceNLS.UI_WirelessWizard_Name);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.informationPage = new WirelessDeviceWizardPage();
        this.addPage((IWizardPage)this.informationPage);
    }

    public boolean performFinish() {
        boolean isProcessOK = true;
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new SwitchFromUSBAndConnectToWirelessRunnable(this));
            EclipseUtils.showInformationDialog((String)RemoteDeviceNLS.WirelessWizard_TitleWirelessConnectionModeWizard, (String)RemoteDeviceNLS.WirelessWizard_WirelessDeviceCreatedSuccessfully);
            AndmoreLogger.collectUsageData((String)"switched_to_wireless", (String)"remote_device", (String)"operation_executed", (String)"org.eclipse.andmore.android.remote", (String)RemoteDevicePlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (InvocationTargetException ite) {
            AndmoreLogger.error(((Object)((Object)this)).getClass(), (String)"Problems switching device to TCP/IP.", (Throwable)ite);
            Status status = new Status(4, "org.eclipse.andmore.android", ite.getTargetException() != null ? ite.getTargetException().getMessage() : ite.getMessage());
            EclipseUtils.showErrorDialog((String)RemoteDeviceNLS.WirelessWizard_TitleWirelessConnectionModeWizard, (String)RemoteDeviceNLS.WirelessWizard_MsgErrorProblemsSwitchingDeviceToTCPIP, (IStatus)status);
            isProcessOK = false;
        }
        catch (InterruptedException interruptedException) {
            isProcessOK = false;
        }
        return isProcessOK;
    }

    public void setInstance(ISerialNumbered instance) {
        this.instance = instance;
    }

    public ISerialNumbered getInstance() {
        return this.instance;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public Properties getProperties() {
        return this.informationPage != null ? this.informationPage.getProperties() : null;
    }

    public void setIp(String host) {
        this.host = host;
    }

    public String getIp() {
        return this.host;
    }

    public String getDeviceName() {
        return this.informationPage.getDeviceName();
    }
}

