/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.remote.ui.wireless;

import java.util.Properties;
import org.eclipse.andmore.android.remote.i18n.RemoteDeviceNLS;
import org.eclipse.andmore.android.remote.ui.wireless.WirelessPropertiesComposite;
import org.eclipse.andmore.android.remote.ui.wireless.WirelessWizard;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sequoyah.device.framework.ui.wizard.IInstanceProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class WirelessDeviceWizardPage
extends WizardPage
implements IInstanceProperties,
WirelessPropertiesComposite.WirelessPropertiesChangedListener {
    private WirelessPropertiesComposite composite;

    public WirelessDeviceWizardPage() {
        super(RemoteDeviceNLS.UI_WirelessWizard_Name);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.put("org.eclipse.andmore.android.remote.hostProperty", this.composite.getHost());
        props.put("org.eclipse.andmore.android.remote.portProperty", Integer.toString(this.composite.getPort()));
        props.put("org.eclipse.andmore.android.remote.timeoutProperty", Integer.toString(this.composite.getTimeout()));
        return props;
    }

    public void createControl(Composite parent) {
        this.setTitle(RemoteDeviceNLS.UI_WirelessInformationPage_Title);
        this.setMessage(RemoteDeviceNLS.UI_WirelessInformationPage_Description);
        this.composite = new WirelessPropertiesComposite(parent, ((WirelessWizard)this.getWizard()).getIp(), ((WirelessWizard)this.getWizard()).getInstance());
        this.composite.addPropertyChangeListener(this);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WirelessDeviceWizardPage.this.composite.removePropertyChangeListener(WirelessDeviceWizardPage.this);
                WirelessDeviceWizardPage.this.composite = null;
                WirelessDeviceWizardPage.this.setControl(null);
            }
        });
        this.setControl((Control)this.composite);
        this.setStatusMessage();
        this.getWizardShell().setSize(this.getWizardShell().computeSize(750, -1));
    }

    private Shell getWizardShell() {
        return this.getWizard().getContainer().getShell();
    }

    private void setStatusMessage() {
        IStatus status = this.composite.getStatus();
        switch (status.getSeverity()) {
            case 4: {
                this.setErrorMessage(status.getMessage());
                this.setMessage(null);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(status.getMessage(), 1);
            }
        }
    }

    public boolean isPageComplete() {
        return this.composite != null && this.composite.getStatus() != null && this.composite.getStatus().getSeverity() != 4;
    }

    @Override
    public void propertiesChanged() {
        this.setStatusMessage();
        this.setPageComplete(this.isPageComplete());
    }

    public String getDeviceName() {
        return this.composite != null ? this.composite.getDeviceName() : "";
    }
}

