/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards;

import org.eclipse.andmore.android.common.utilities.ui.WidgetsFactory;
import org.eclipse.andmore.android.wizards.elements.IBaseBlock;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public abstract class BaseWizardPage
extends WizardPage
implements Listener {
    private Composite composite;
    private GridLayout layout;
    protected IBaseBlock block;
    private String helpID = null;

    public BaseWizardPage(IBaseBlock block, String title, String description) {
        this(block, title, description, null);
        this.block = block;
    }

    public BaseWizardPage(IBaseBlock block, String title, String description, String contextHelpID) {
        super(title);
        this.setTitle(title);
        this.setDescription(description);
        this.block = block;
        this.helpID = contextHelpID;
    }

    public void createControl(Composite parent) {
        this.getComposite(parent).setLayout((Layout)this.getLayout());
        if (this.block != null) {
            this.block.setShell(this.getShell());
            Composite blockComposite = this.block.createContent(this.getComposite(parent));
            if (this.helpID != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)blockComposite, this.helpID);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getComposite(parent), this.helpID);
            }
        }
        this.setControl((Control)this.getComposite(parent));
        this.setErrorMessage(null);
        this.getComposite(parent).addListener(24, (Listener)this);
        this.getComposite(parent).addListener(13, (Listener)this);
    }

    protected Composite getComposite(Composite parent) {
        if (this.composite == null) {
            this.composite = WidgetsFactory.createComposite(parent);
        }
        return this.composite;
    }

    protected GridLayout getLayout() {
        if (this.layout == null) {
            this.layout = WidgetsFactory.createGridLayout();
        }
        return this.layout;
    }

    public void handleEvent(Event event) {
        String message = this.block.getErrorMessage();
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public boolean isPageComplete() {
        if (this.block == null) {
            return true;
        }
        return this.block.isPageComplete();
    }

    public boolean canFlipToNextPage() {
        if (this.block == null) {
            return true;
        }
        return this.block.canFlipToNextPage() && this.getNextPage() != null;
    }
}

