/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.dom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.model.manifest.dom.AbstractIconLabelNameNode;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.core.runtime.IStatus;

public class PermissionNode
extends AbstractIconLabelNameNode {
    private static Map<String, ProtectionLevel> protectionLevelMap;
    private String propDescription = null;
    private String propPermissionGroup = null;
    private ProtectionLevel propProtectionLevel = null;

    static {
        defaultProperties.add("android:description");
        defaultProperties.add("android:permissionGroup");
        defaultProperties.add("android:protectionLevel");
        protectionLevelMap = new HashMap<String, ProtectionLevel>();
        protectionLevelMap.put(ProtectionLevel.normal.toString().toLowerCase(), ProtectionLevel.normal);
        protectionLevelMap.put(ProtectionLevel.dangerous.toString().toLowerCase(), ProtectionLevel.dangerous);
        protectionLevelMap.put(ProtectionLevel.signature.toString().toLowerCase(), ProtectionLevel.signature);
        protectionLevelMap.put(ProtectionLevel.signatureOrSystem.toString().toLowerCase(), ProtectionLevel.signatureOrSystem);
    }

    public static ProtectionLevel getProtectionLevel(String name) {
        ProtectionLevel protectionLevel = null;
        if (name != null) {
            String pl = name.trim().toLowerCase();
            protectionLevel = protectionLevelMap.get(pl);
        }
        return protectionLevel;
    }

    public static String getProtectionLevelName(ProtectionLevel protectionLevel) {
        String name = "";
        if (protectionLevel != null) {
            name = protectionLevel.toString();
        }
        return name;
    }

    public PermissionNode(String name) {
        super(name);
    }

    @Override
    protected boolean canContains(AndroidManifestNode.NodeType nodeType) {
        return false;
    }

    @Override
    protected void addAdditionalProperties() {
        String protectionLevelName = PermissionNode.getProtectionLevelName(this.propProtectionLevel);
        this.properties.put("android:protectionLevel", protectionLevelName);
        if (this.propDescription != null && this.propDescription.length() > 0) {
            this.properties.put("android:description", this.propDescription);
        }
        if (this.propPermissionGroup != null && this.propPermissionGroup.trim().length() > 0) {
            this.properties.put("android:permissionGroup", this.propPermissionGroup);
        }
    }

    @Override
    public AndroidManifestNode.NodeType getNodeType() {
        return AndroidManifestNode.NodeType.Permission;
    }

    @Override
    protected boolean isNodeValid() {
        boolean isProtectionLevelValid;
        boolean bl = isProtectionLevelValid = this.propProtectionLevel != null;
        return super.isNodeValid() && isProtectionLevelValid;
    }

    public String getDescription() {
        return this.propDescription;
    }

    public void setDescription(String description) {
        this.propDescription = description;
    }

    public String getPermissionGroup() {
        return this.propPermissionGroup;
    }

    public void setPermissionGroup(String permissionGroup) {
        this.propPermissionGroup = permissionGroup;
    }

    public ProtectionLevel getProtectionLevel() {
        return this.propProtectionLevel;
    }

    public void setProtectionLevel(ProtectionLevel protectionLevel) {
        this.propProtectionLevel = protectionLevel;
    }

    @Override
    protected List<IStatus> getSpecificNodeProblems() {
        return null;
    }

    public static enum ProtectionLevel {
        normal,
        dangerous,
        signature,
        signatureOrSystem;

    }
}

