/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.dom;

import java.util.Map;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.IAndroidManifestProperties;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractIconLabelNameNode
extends AndroidManifestNode
implements IAndroidManifestProperties {
    protected String propIcon = null;
    protected String propLabel = null;
    protected String propName = null;

    static {
        defaultProperties.add("android:icon");
        defaultProperties.add("android:label");
        defaultProperties.add("android:name");
    }

    protected AbstractIconLabelNameNode(String name) {
        Assert.isLegal((name != null ? 1 : 0) != 0);
        this.propName = name;
    }

    @Override
    protected boolean isNodeValid() {
        return this.propName.trim().length() > 0;
    }

    @Override
    public Map<String, String> getNodeProperties() {
        this.properties.clear();
        if (this.propName != null && this.propName.trim().length() > 0) {
            this.properties.put("android:name", this.propName);
        }
        if (this.propIcon != null && this.propIcon.trim().length() > 0) {
            this.properties.put("android:icon", this.propIcon);
        }
        if (this.propLabel != null && this.propLabel.trim().length() > 0) {
            this.properties.put("android:label", this.propLabel);
        }
        this.addAdditionalProperties();
        return this.properties;
    }

    protected abstract void addAdditionalProperties();

    public String getIcon() {
        return this.propIcon;
    }

    public void setIcon(String icon) {
        this.propIcon = icon;
    }

    public String getLabel() {
        return this.propLabel;
    }

    public void setLabel(String label) {
        this.propLabel = label;
    }

    public String getName() {
        return this.propName;
    }

    public void setName(String name) {
        Assert.isLegal((name != null ? 1 : 0) != 0);
        this.propName = name;
    }
}

