/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.utilities;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class PluginUtils {
    public static final int OS_WINDOWS = 0;
    public static final int OS_LINUX = 1;

    public static Object getExecutable(String extensionId, String elementName, String executableName) throws Exception {
        Object executable = null;
        IExtension fromExtension = PluginUtils.getExtension(extensionId);
        if (fromExtension != null && elementName != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = fromExtension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (elementName.equals(element.getName())) {
                    try {
                        executable = element.createExecutableExtension(executableName);
                    }
                    catch (Exception e) {
                        String errMsg = NLS.bind((String)UtilitiesNLS.EXC_PluginUtils_ErrorGettingTheExecutableFromExtensionPoint, (Object[])new Object[]{executableName, elementName, extensionId});
                        AndmoreLogger.error(PluginUtils.class, errMsg, (Throwable)e);
                        throw new Exception(errMsg, e);
                    }
                }
                ++n2;
            }
        }
        return executable;
    }

    public static Object getExecutable(String extensionId, String elementName) throws Exception {
        return PluginUtils.getExecutable(extensionId, elementName, "class");
    }

    public static IExtension getExtension(String extensionPointId, String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension extension = registry.getExtension(extensionPointId, extensionId);
        return extension;
    }

    public static IExtension getExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension extension = registry.getExtension(extensionId);
        return extension;
    }

    public static String getExtensionLabel(String extensionPointId, String extensionId) {
        IExtension extension = PluginUtils.getExtension(extensionPointId, extensionId);
        String extensionLabel = extension != null ? extension.getLabel() : extensionId;
        return extensionLabel;
    }

    public static String getExtensionLabel(String extensionId) {
        IExtension extension = PluginUtils.getExtension(extensionId);
        String extensionLabel = extension != null ? extension.getLabel() : extensionId;
        return extensionLabel;
    }

    public static Collection<String> getInstalledPlugins(String extensionPointId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        LinkedHashSet<String> pluginIds = new LinkedHashSet<String>();
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                pluginIds.add(extension.getUniqueIdentifier());
                ++n2;
            }
        }
        return pluginIds;
    }

    public static String[] getInstalledPluginsAsArray(String extensionPointId) {
        Collection<String> sampleAppPluginIds = PluginUtils.getInstalledPlugins(extensionPointId);
        String[] sampleAppPluginIdsArray = new String[sampleAppPluginIds.size()];
        return sampleAppPluginIds.toArray(sampleAppPluginIdsArray);
    }

    public static Collection<String> getPlatformNamespaces() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        String[] namespaces = extensionRegistry.getNamespaces();
        return Arrays.asList(namespaces);
    }

    public static String getPluginAttribute(String extensionPointId, String extensionId, String element, String attribute) {
        IExtension fromPlugin = PluginUtils.getExtension(extensionPointId, extensionId);
        return PluginUtils.getPluginAttribute(fromPlugin, element, attribute);
    }

    public static String getPluginAttribute(String extensionId, String element, String attribute) {
        IExtension fromPlugin = PluginUtils.getExtension(extensionId);
        return PluginUtils.getPluginAttribute(fromPlugin, element, attribute);
    }

    public static String getPluginAttribute(IExtension fromExtension, String element, String attribute) {
        String attributeValue = null;
        if (fromExtension != null) {
            IConfigurationElement[] ceArray;
            IConfigurationElement[] iConfigurationElementArray = ceArray = fromExtension.getConfigurationElements();
            int n = ceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if (ce != null && ce.getName().equals(element)) {
                    attributeValue = ce.getAttribute(attribute);
                }
                ++n2;
            }
        }
        return attributeValue;
    }

    public static Collection<Map<String, String>> getPluginAttributes(String extensionId, String element) {
        IExtension fromExtension = PluginUtils.getExtension(extensionId);
        return PluginUtils.getPluginAttributes(fromExtension, element);
    }

    public static Collection<Map<String, String>> getPluginAttributes(IExtension fromExtension, String element) {
        LinkedHashSet<Map<String, String>> elementValues = new LinkedHashSet<Map<String, String>>();
        if (fromExtension != null) {
            IConfigurationElement[] ceArray;
            IConfigurationElement[] iConfigurationElementArray = ceArray = fromExtension.getConfigurationElements();
            int n = ceArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] attributes;
                IConfigurationElement ce = iConfigurationElementArray[n2];
                if (ce != null && ce.getName().equals(element) && (attributes = ce.getAttributeNames()) != null && attributes.length > 0) {
                    int attributesLenght = attributes.length;
                    LinkedHashMap<String, String> attributesMap = new LinkedHashMap<String, String>(attributesLenght, attributesLenght);
                    String[] stringArray = attributes;
                    int n3 = attributes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String attribute = stringArray[n4];
                        String attributeValue = ce.getAttribute(attribute);
                        if (attributeValue != null && !attributeValue.equals("")) {
                            attributesMap.put(attribute, attributeValue);
                        }
                        ++n4;
                    }
                    if (attributesMap.size() == attributesLenght) {
                        elementValues.add(attributesMap);
                    }
                }
                ++n2;
            }
        }
        return elementValues;
    }

    public static File getPluginInstallationPath(Plugin plugin) {
        Bundle pluginBundle = plugin.getBundle();
        return PluginUtils.getPluginInstallationPath(pluginBundle);
    }

    public static File getPluginInstallationPath(String extensionPointId, String extensionId) {
        IExtension extension = PluginUtils.getExtension(extensionPointId, extensionId);
        return PluginUtils.getPluginInstallationPath(extension);
    }

    public static File getPluginInstallationPath(IExtension extension) {
        String pluginId = extension.getNamespaceIdentifier();
        Bundle pluginBundle = Platform.getBundle((String)pluginId);
        return PluginUtils.getPluginInstallationPath(pluginBundle);
    }

    public static File getPluginInstallationPath(Bundle pluginBundle) {
        File relativeInstalationPath = null;
        try {
            relativeInstalationPath = new File(FileLocator.toFileURL((URL)pluginBundle.getEntry("")).getFile());
        }
        catch (IOException e) {
            AndmoreLogger.warn("Illegal state while getting plugin installation path (" + e.getMessage() + ").");
        }
        if (relativeInstalationPath == null) {
            String platformPath = Platform.getInstallLocation().getURL().getPath();
            String pluginPath = pluginBundle.getLocation();
            int removeIndex = pluginPath.indexOf("@");
            pluginPath = pluginPath.substring(removeIndex + 1);
            relativeInstalationPath = new File(platformPath, pluginPath);
        }
        return FileUtil.getCanonicalFile(relativeInstalationPath);
    }

    public static File getPluginResource(Plugin plugin, String resource) throws Exception {
        File pluginPath = PluginUtils.getPluginInstallationPath(plugin);
        File resourceFile = new File(pluginPath, resource);
        File canonicalFile = null;
        canonicalFile = FileUtil.getCanonicalFile(resourceFile);
        return canonicalFile;
    }

    public static boolean isInstalled(String extensionPointId, String extensionId) {
        return PluginUtils.getExtension(extensionPointId, extensionId) != null;
    }

    public static boolean isInstalled(String extensionId) {
        return PluginUtils.getExtension(extensionId) != null;
    }

    public static int getOS() {
        int result = -1;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("linux") > -1) {
            result = 1;
        } else if (osName.indexOf("windows") > -1) {
            result = 0;
        }
        return result;
    }

    public static final File getFileOnPreferenceDirectory(Plugin plugin, String filename) throws Exception {
        File targetXmlFile = null;
        try {
            IPath path = plugin.getStateLocation();
            if (path != null) {
                path = path.append(filename);
                targetXmlFile = path.toFile().getAbsoluteFile();
            }
        }
        catch (IllegalStateException e) {
            AndmoreLogger.warn("Illegal state while getting file on preferences directory (" + e.getMessage() + ").");
        }
        if (targetXmlFile == null) {
            throw new AndroidException("Could use file " + filename + " on preferences plug-in " + plugin.getBundle().getBundleId());
        }
        return targetXmlFile;
    }
}

