/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.preferences;

import org.eclipse.andmore.android.common.CommonPlugin;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class DialogWithToggleUtils {
    private static final String TOGGLE_DIALOG = ".toggle.dialog";

    private static IEclipsePreferences getPreferences() {
        IScopeContext scope = InstanceScope.INSTANCE;
        return scope.getNode("org.eclipse.andmore.android.common");
    }

    public static boolean showQuestion(String preferenceKey, final String title, final String message) {
        final Boolean[] reply = new Boolean[1];
        final String prefKey = String.valueOf(preferenceKey) + TOGGLE_DIALOG;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench;
                IWorkbenchWindow ww;
                Shell shell;
                MessageDialogWithToggle dialog;
                CommonPlugin plugin = CommonPlugin.getDefault();
                IPreferenceStore store = plugin.getPreferenceStore();
                String preferenceValue = store.getString(prefKey);
                reply[0] = "prompt".equals(preferenceValue) || preferenceValue.length() == 0 ? Boolean.valueOf((dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)(shell = (ww = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()).getShell()), (String)title, (String)message, (String)UtilitiesNLS.UI_DoNotShowMEAgain, (boolean)false, (IPreferenceStore)store, (String)prefKey)).getReturnCode() == 2) : Boolean.valueOf(preferenceValue.equals("always"));
            }
        });
        return reply[0];
    }

    public static void showInformation(String preferenceKey, final String title, final String message) {
        final String prefKey = String.valueOf(preferenceKey) + TOGGLE_DIALOG;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CommonPlugin plugin = CommonPlugin.getDefault();
                IPreferenceStore store = plugin.getPreferenceStore();
                String preferenceValue = store.getString(prefKey);
                if ("prompt".equals(preferenceValue) || preferenceValue.length() == 0) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                    Shell shell = ww.getShell();
                    MessageDialogWithToggle.openInformation((Shell)shell, (String)title, (String)message, (String)UtilitiesNLS.UI_DoNotShowMEAgain, (boolean)false, (IPreferenceStore)store, (String)prefKey);
                }
            }
        });
    }

    public static void showWarning(String preferenceKey, final String title, final String message) {
        final String prefKey = String.valueOf(preferenceKey) + TOGGLE_DIALOG;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CommonPlugin plugin = CommonPlugin.getDefault();
                IPreferenceStore store = plugin.getPreferenceStore();
                String preferenceValue = store.getString(prefKey);
                if ("prompt".equals(preferenceValue) || preferenceValue.length() == 0) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                    Shell shell = ww.getShell();
                    MessageDialogWithToggle.openWarning((Shell)shell, (String)title, (String)message, (String)UtilitiesNLS.UI_DoNotShowMEAgain, (boolean)false, (IPreferenceStore)store, (String)prefKey);
                }
            }
        });
    }

    public static boolean showConfirmation(String preferenceKey, final String title, final String message) {
        final Boolean[] reply = new Boolean[1];
        final String prefKey = String.valueOf(preferenceKey) + TOGGLE_DIALOG;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench;
                IWorkbenchWindow ww;
                Shell shell;
                MessageDialogWithToggle dialog;
                CommonPlugin plugin = CommonPlugin.getDefault();
                IPreferenceStore store = plugin.getPreferenceStore();
                String preferenceValue = store.getString(prefKey);
                reply[0] = "prompt".equals(preferenceValue) || preferenceValue.length() == 0 ? Boolean.valueOf((dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)(shell = (ww = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()).getShell()), (String)title, (String)message, (String)UtilitiesNLS.UI_AlwaysProceed, (boolean)false, (IPreferenceStore)store, (String)prefKey)).getReturnCode() == 0) : Boolean.valueOf(preferenceValue.equals("always"));
            }
        });
        return reply[0];
    }

    public static void showError(String preferenceKey, final String title, final String message) {
        final String prefKey = String.valueOf(preferenceKey) + TOGGLE_DIALOG;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                CommonPlugin plugin = CommonPlugin.getDefault();
                IPreferenceStore store = plugin.getPreferenceStore();
                String preferenceValue = store.getString(prefKey);
                if ("prompt".equals(preferenceValue) || preferenceValue.length() == 0) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                    Shell shell = ww.getShell();
                    MessageDialogWithToggle.openError((Shell)shell, (String)title, (String)message, (String)UtilitiesNLS.UI_DoNotShowMEAgain, (boolean)false, (IPreferenceStore)store, (String)prefKey);
                }
            }
        });
    }

    public static void resetAllDialogsConfiguration() {
        String[] propertyNames;
        IEclipsePreferences preferences = DialogWithToggleUtils.getPreferences();
        try {
            propertyNames = preferences.keys();
        }
        catch (BackingStoreException backingStoreException) {
            propertyNames = new String[]{};
        }
        String[] stringArray = propertyNames;
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            if (propertyName.contains(TOGGLE_DIALOG)) {
                preferences.put(propertyName, "prompt");
            }
            ++n2;
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static void setToggleDialogPreferenceKey(String preferenceKey, String value) {
        String prefKey = String.valueOf(preferenceKey) + TOGGLE_DIALOG;
        CommonPlugin plugin = CommonPlugin.getDefault();
        IPreferenceStore store = plugin.getPreferenceStore();
        store.setValue(prefKey, value);
    }

    public static String getToggleDialogPreferenceKey(String preferenceKey) {
        String prefKey = String.valueOf(preferenceKey) + TOGGLE_DIALOG;
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        String prefValue = null;
        if (!store.isDefault(prefKey)) {
            prefValue = store.getString(prefKey);
        }
        return prefValue;
    }
}

