/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.views;

import java.util.Collections;
import java.util.List;
import org.eclipse.andmore.android.certmanager.event.IKeyStoreModelListener;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEvent;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEventManager;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreRootNode;
import org.eclipse.andmore.android.certmanager.ui.model.SigningAndKeysModelManager;
import org.eclipse.andmore.android.certmanager.ui.tree.ExpiresInColumnLabelProvider;
import org.eclipse.andmore.android.certmanager.ui.tree.KeystoreManagerTreeContentProvider;
import org.eclipse.andmore.android.certmanager.ui.tree.LastBackupDateColumnLabelProvider;
import org.eclipse.andmore.android.certmanager.ui.tree.NameAliasColumnLabelProvider;
import org.eclipse.andmore.android.certmanager.ui.tree.PathColumnLabelProvider;
import org.eclipse.andmore.android.certmanager.ui.tree.TypeColumnLabelProvider;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class KeystoreManagerView
extends ViewPart
implements IKeyStoreModelListener {
    public static final String ID = "org.eclipse.andmore.android.packaging.ui.signingview";
    private TreeViewer viewer;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 268503810);
        this.viewer.setUseHashlookup(true);
        this.viewer.setAutoExpandLevel(0);
        this.viewer.setContentProvider((IContentProvider)new KeystoreManagerTreeContentProvider(this.viewer));
        this.viewer.setInput(this.getInitalInput());
        this.viewer.expandToLevel(this.getInitalInput(), 1);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        Tree tree = this.viewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.viewer, 0);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new NameAliasColumnLabelProvider());
        TreeColumn trclmnNewColumn = treeViewerColumn.getColumn();
        trclmnNewColumn.setWidth(250);
        trclmnNewColumn.setText(CertificateManagerNLS.CertificateManagerView_NameAlias_ColumnName);
        tree.setSortColumn(treeViewerColumn.getColumn());
        tree.setSortDirection(1024);
        treeViewerColumn = new TreeViewerColumn(this.viewer, 0);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new TypeColumnLabelProvider());
        trclmnNewColumn = treeViewerColumn.getColumn();
        trclmnNewColumn.setWidth(75);
        trclmnNewColumn.setText(CertificateManagerNLS.CertificateManagerView_Type_ColumnName);
        treeViewerColumn = new TreeViewerColumn(this.viewer, 0);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new ExpiresInColumnLabelProvider());
        TreeColumn trclmnExpiresIn = treeViewerColumn.getColumn();
        trclmnExpiresIn.setWidth(100);
        trclmnExpiresIn.setText(CertificateManagerNLS.CertificateManagerView_ExpiresIn_ColumnName);
        treeViewerColumn = new TreeViewerColumn(this.viewer, 0);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new LastBackupDateColumnLabelProvider());
        TreeColumn trclmnLastBackupDate = treeViewerColumn.getColumn();
        trclmnLastBackupDate.setWidth(125);
        trclmnLastBackupDate.setText(CertificateManagerNLS.CertificateManagerView_LastBackupDate_ColumnName);
        treeViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new PathColumnLabelProvider());
        TreeColumn trclmnPath = treeViewerColumn.getColumn();
        trclmnPath.setWidth(500);
        trclmnPath.setText(CertificateManagerNLS.CertificateManagerView_Path_ColumnName);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.andmore.android.certmanager.viewer");
        this.hookContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        KeyStoreModelEventManager.getInstance().addListener(this);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                KeystoreManagerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private Object getInitalInput() {
        return SigningAndKeysModelManager.getInstance().getKeyStoresRootNode();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void dispose() {
        super.dispose();
        KeyStoreModelEventManager.getInstance().removeListener(this);
    }

    @Override
    public void handleNodeAdditionEvent(final KeyStoreModelEvent keyStoreModeEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ITreeNode treeNodeItem = keyStoreModeEvent.getTreeNodeItem();
                    ITreeNode parentNode = treeNodeItem.getParent();
                    if (KeystoreManagerView.this.getTreeViewer().getExpandedState((Object)parentNode) || parentNode instanceof KeyStoreRootNode) {
                        KeystoreManagerView.this.getTreeViewer().add((Object)parentNode, (Object)treeNodeItem);
                    } else {
                        List<ITreeNode> children;
                        try {
                            children = parentNode.getChildren();
                        }
                        catch (KeyStoreManagerException keyStoreManagerException) {
                            children = Collections.emptyList();
                        }
                        if (children.size() > 0) {
                            KeystoreManagerView.this.getTreeViewer().setChildCount((Object)parentNode, children.size());
                        }
                    }
                }
            });
        }
    }

    @Override
    public void handleNodeRemovalEvent(final KeyStoreModelEvent keyStoreModeEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!KeystoreManagerView.this.getTreeViewer().getTree().isDisposed()) {
                        KeystoreManagerView.this.getTreeViewer().remove((Object)keyStoreModeEvent.getTreeNodeItem());
                    }
                }
            });
        }
    }

    @Override
    public void handleNodeUpdateEvent(final KeyStoreModelEvent keyStoreModeEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ITreeNode treeNode = keyStoreModeEvent.getTreeNodeItem();
                    KeystoreManagerView.this.getTreeViewer().update((Object)treeNode, null);
                }
            });
        }
    }

    @Override
    public void handleNodeCollapseEvent(final KeyStoreModelEvent keyStoreModelEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ITreeNode treeNode = keyStoreModelEvent.getTreeNodeItem();
                    KeystoreManagerView.this.getTreeViewer().remove((Object)treeNode);
                    KeystoreManagerView.this.getTreeViewer().add((Object)treeNode.getParent(), (Object)treeNode);
                }
            });
        }
    }

    @Override
    public void handleNodeRefreshEvent(final KeyStoreModelEvent keyStoreModelEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ITreeNode treeNode = keyStoreModelEvent.getTreeNodeItem();
                    if (treeNode != null) {
                        try {
                            KeystoreManagerView.this.getTreeViewer().remove((Object)treeNode, treeNode.getChildren().toArray());
                        }
                        catch (KeyStoreManagerException e) {
                            AndmoreLogger.error((String)("Error while accessing keystore manager. " + e.getMessage()));
                        }
                        KeystoreManagerView.this.getTreeViewer().refresh((Object)treeNode, true);
                    }
                }
            });
        }
    }

    @Override
    public void handleNodeClearEvent(final KeyStoreModelEvent keyStoreModelEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ITreeNode treeNode = keyStoreModelEvent.getTreeNodeItem();
                    if (treeNode != null) {
                        try {
                            KeystoreManagerView.this.getTreeViewer().remove((Object)treeNode, treeNode.getChildren().toArray());
                            KeystoreManagerView.this.getTreeViewer().setChildCount((Object)treeNode, 0);
                        }
                        catch (KeyStoreManagerException e) {
                            AndmoreLogger.error((String)("Error while accessing keystore manager. " + e.getMessage()));
                        }
                    }
                }
            });
        }
    }
}

