/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.tree;

import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class NameAliasColumnLabelProvider
extends ColumnLabelProvider {
    final IDecoratorManager decorator = PlatformUI.getWorkbench().getDecoratorManager();

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof ITreeNode) {
            ITreeNode node = (ITreeNode)element;
            Image defaultImage = null;
            if (node.getIcon() != null) {
                defaultImage = node.getIcon().createImage();
                result = this.decorator.decorateImage(defaultImage, element);
            }
            if (result == null) {
                result = defaultImage;
            }
        }
        return result;
    }

    public String getText(Object element) {
        if (element instanceof ITreeNode) {
            ITreeNode node = (ITreeNode)element;
            return node.getName();
        }
        return "";
    }

    public void update(ViewerCell cell) {
        Object cellElement = cell.getElement();
        cell.setText(this.getText(cellElement));
        if (this.getImage(cellElement) != null) {
            cell.setImage(this.getImage(cellElement));
        }
    }

    public String getToolTipText(Object element) {
        if (element instanceof ITreeNode) {
            ITreeNode treeNode = (ITreeNode)element;
            return treeNode.getTooltip();
        }
        return super.getToolTipText(element);
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 4000;
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 500;
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public void addListener(ILabelProviderListener listener) {
        this.decorator.addListener(listener);
        super.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.decorator.removeListener(listener);
        super.removeListener(listener);
    }
}

