/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.tree;

import java.util.List;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class KeystoreManagerTreeContentProvider
implements ILazyTreeContentProvider {
    private final TreeViewer treeViewer;

    public KeystoreManagerTreeContentProvider(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void updateElement(Object parent, int index) {
        if (parent instanceof ITreeNode) {
            ITreeNode parentNode = (ITreeNode)parent;
            ITreeNode child = null;
            try {
                List<ITreeNode> children = parentNode.getChildren();
                if (!children.isEmpty()) {
                    child = children.get(index);
                }
            }
            catch (Exception exception) {
                child = null;
            }
            if (child != null) {
                this.treeViewer.replace(parent, index, (Object)child);
                try {
                    if (child.getChildren().isEmpty()) {
                        this.treeViewer.setHasChildren((Object)child, !child.isLeaf());
                    } else {
                        this.treeViewer.setChildCount((Object)child, child.getChildren().size());
                    }
                }
                catch (KeyStoreManagerException e) {
                    AndmoreLogger.error((String)("Error while accessing keystore manager. " + e.getMessage()));
                }
            }
        }
    }

    public void updateChildCount(Object element, int currentChildCount) {
        if (element instanceof ITreeNode) {
            ITreeNode treeNode = (ITreeNode)element;
            int childCount = 0;
            try {
                treeNode.refresh();
                List<ITreeNode> children = treeNode.getChildren();
                if (!children.isEmpty()) {
                    childCount = children.size();
                }
            }
            catch (KeyStoreManagerException e) {
                AndmoreLogger.error((String)e.getMessage());
            }
            if (childCount != currentChildCount) {
                this.treeViewer.setChildCount(element, childCount);
            }
        }
    }

    public ITreeNode getParent(Object element) {
        if (element instanceof ITreeNode) {
            ITreeNode treeNode = (ITreeNode)element;
            return treeNode.getParent();
        }
        return null;
    }
}

