/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.model;

import java.io.File;
import java.util.List;
import org.eclipse.andmore.android.certmanager.core.BackwardKeystoreManager;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreRootNode;
import org.eclipse.andmore.android.certmanager.views.KeystoreManagerView;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SigningAndKeysModelManager {
    private KeyStoreRootNode keyStoresRootNode = new KeyStoreRootNode();
    private static SigningAndKeysModelManager _instance = null;

    private SigningAndKeysModelManager() {
    }

    public static synchronized SigningAndKeysModelManager getInstance() {
        if (_instance == null) {
            _instance = new SigningAndKeysModelManager();
            _instance.populateKeyStoreRootNode();
        }
        return _instance;
    }

    public File[] getKeystoreFiles() {
        List<ITreeNode> nodes = this.keyStoresRootNode.getChildren();
        File[] files = new File[nodes.size()];
        int i = 0;
        for (ITreeNode node : nodes) {
            File file = ((KeyStoreNode)node).getFile();
            files[i++] = file;
        }
        return files;
    }

    public KeyStoreRootNode populateKeyStoreRootNode() {
        try {
            List<IKeyStore> keyStores = KeyStoreManager.getInstance().getKeyStores();
            if (keyStores != null) {
                if (keyStores.size() > 0) {
                    for (IKeyStore keyStore : keyStores) {
                        if (!(keyStore instanceof KeyStoreNode)) continue;
                        this.keyStoresRootNode.addKeyStoreNode((KeyStoreNode)keyStore);
                    }
                } else {
                    BackwardKeystoreManager backwardKeystoreManager = new BackwardKeystoreManager();
                    backwardKeystoreManager.mapOldKeystore();
                }
            }
        }
        catch (Exception e) {
            AndmoreLogger.error(KeystoreManagerView.class, (String)e.getMessage(), (Throwable)e);
            EclipseUtils.showErrorDialog((String)CertificateManagerNLS.KeystoreManagerView_ErrorLoadingMappedKeystoresFromPersistence, (String)e.getMessage());
        }
        return this.keyStoresRootNode;
    }

    public void unmapKeyStore(KeyStoreNode keyStoreNode) {
        this.keyStoresRootNode.removeKeyStore(keyStoreNode);
        try {
            File file = keyStoreNode.getFile();
            PasswordProvider passwordProvider = new PasswordProvider(file);
            passwordProvider.deleteKeyStoreSavedPasswordNode();
            KeyStoreManager.getInstance().removeKeyStore(keyStoreNode);
        }
        catch (KeyStoreManagerException e) {
            EclipseUtils.showErrorDialog((String)"Error unmapping KeyStore", (String)NLS.bind((String)"Could not unmap the keystore file {0}", (Object)keyStoreNode.getFile()), (IStatus)new Status(4, "Error unmapping KeyStore", "org.eclipse.andmore.android.certmanager", (Throwable)((Object)e)));
        }
    }

    public void mapKeyStore(KeyStoreNode keyStoreNode) throws KeyStoreManagerException {
        this.keyStoresRootNode.addKeyStoreNode(keyStoreNode);
        KeyStoreManager.getInstance().addKeyStore(keyStoreNode);
    }

    public KeyStoreRootNode getKeyStoresRootNode() {
        return this.keyStoresRootNode;
    }
}

