/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEvent;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEventManager;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.AbstractTreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

public class KeyStoreRootNode
extends AbstractTreeNode {
    private final List<ITreeNode> keyStores = new ArrayList<ITreeNode>();

    public void addKeyStoreNode(KeyStoreNode keyStoreModel) throws KeyStoreManagerException {
        if (this.keyStores.contains(keyStoreModel)) {
            throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.KeyStoreRootNode_Error_AlreadyMappedKeystorePath, (Object)keyStoreModel.getFile().getAbsolutePath()));
        }
        this.keyStores.add(keyStoreModel);
        keyStoreModel.setParent(this);
        KeyStoreModelEventManager.getInstance().fireEvent(keyStoreModel, KeyStoreModelEvent.EventType.ADD);
    }

    public void removeKeyStore(KeyStoreNode keyStoreModel) {
        this.keyStores.remove(keyStoreModel);
        KeyStoreModelEventManager.getInstance().fireEvent(keyStoreModel, KeyStoreModelEvent.EventType.REMOVE);
        File keysToreFile = keyStoreModel.getFile();
        PasswordProvider password = new PasswordProvider(keysToreFile);
        try {
            password.deleteKeyStoreSavedPasswordNode();
        }
        catch (KeyStoreManagerException e) {
            AndmoreLogger.error((String)("Error while accessing keystore manager. " + e.getMessage()));
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getId() {
        return "";
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public ImageDescriptor getIcon() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public ITreeNode getParent() {
        return null;
    }

    @Override
    public List<ITreeNode> getChildren() {
        return new ArrayList<ITreeNode>(this.keyStores);
    }
}

