/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.model;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.eclipse.andmore.android.certmanager.core.KeyStoreUtils;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.AbstractTreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.CertificateDetailsInfo;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStoreEntry;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EntryNode
extends AbstractTreeNode
implements IKeyStoreEntry {
    public static final String KEY_PAIR_DER_OBJ_ID = "2.16.840.1.113793.23";
    public static final int KEY_PASSWORD_MIN_SIZE = 6;
    protected String alias;
    private final String KEY_NONSAVED_PASSWORD_ICON_PATH = "icons/key.png";
    private final String KEY_SAVED_PASSWORD_ICON_PATH = "icons/key_saved_password.png";

    protected EntryNode() {
    }

    public EntryNode(ITreeNode keyStoreModel, String alias) throws KeyStoreManagerException {
        X509Certificate cert;
        this.alias = alias.toLowerCase();
        this.setParent(keyStoreModel);
        if (!this.isKeyPairEntry()) {
            keyStoreModel.addChild(this);
        }
        if ((cert = this.getX509Certificate()) != null) {
            try {
                X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
                RDN commonName = x500name.getRDNs(BCStyle.CN).length >= 1 ? x500name.getRDNs(BCStyle.CN)[0] : null;
                RDN organization = x500name.getRDNs(BCStyle.O).length >= 1 ? x500name.getRDNs(BCStyle.O)[0] : null;
                String org = organization != null ? organization.getFirst().getValue().toString() : CertificateManagerNLS.CertificateInfoDialog_NotAvailableProperty;
                String name = commonName != null ? commonName.getFirst().getValue().toString() : CertificateManagerNLS.CertificateInfoDialog_NotAvailableProperty;
                this.setTooltip(NLS.bind((String)CertificateManagerNLS.CertificateBlock_KeyTooltip, (Object)org, (Object)name));
            }
            catch (CertificateEncodingException e) {
                String errorMsg = "Error getting data from certificate";
                AndmoreLogger.error(EntryNode.class, (String)errorMsg, (Throwable)e);
                throw new KeyStoreManagerException(errorMsg, e);
            }
        }
    }

    @Override
    public IKeyStore getKeyStoreNode() {
        return (KeyStoreNode)this.getParent();
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isCertificateEntry() throws KeyStoreException, KeyStoreManagerException {
        return this.getKeyStoreNode().getKeyStore().isCertificateEntry(this.alias);
    }

    @Override
    public boolean isKeyEntry() throws KeyStoreException, KeyStoreManagerException {
        return this.getKeyStoreNode().getKeyStore().isKeyEntry(this.alias);
    }

    @Override
    public boolean isKeyPairEntry() {
        X509Certificate certificate = this.getX509Certificate();
        Set<String> criticalOIDs = certificate.getCriticalExtensionOIDs();
        return criticalOIDs != null && criticalOIDs.contains(KEY_PAIR_DER_OBJ_ID);
    }

    private Certificate getCertificate() throws KeyStoreException, KeyStoreManagerException {
        Certificate certificate = null;
        KeyStore keyStore = this.getKeyStoreNode().getKeyStore();
        if (keyStore.isCertificateEntry(this.alias)) {
            certificate = keyStore.getCertificate(this.alias);
        } else {
            AndmoreLogger.error((String)NLS.bind((String)CertificateManagerNLS.EntryNode_NotFoundOrTypeWrong, (Object)this.alias));
        }
        return certificate;
    }

    @Override
    public Key getKey(String password) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, KeyStoreManagerException {
        Key key = null;
        KeyStore keyStore = this.getKeyStoreNode().getKeyStore();
        if (keyStore.isKeyEntry(this.alias)) {
            key = keyStore.getKey(this.alias, password.toCharArray());
        }
        return key;
    }

    @Override
    public PrivateKey getPrivateKey(String password) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, KeyStoreManagerException, InvalidKeyException {
        Key key = this.getKey(password);
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("This is not a private key");
        }
        return (PrivateKey)key;
    }

    public KeyStore.Entry getKeyEntry(String password) throws KeyStoreException, NoSuchAlgorithmException, KeyStoreManagerException, UnrecoverableEntryException {
        KeyStore.Entry key = null;
        KeyStore keyStore = this.getKeyStoreNode().getKeyStore();
        if (keyStore.isKeyEntry(this.alias)) {
            key = keyStore.getEntry(this.alias, new KeyStore.PasswordProtection(password.toCharArray()));
        }
        return key;
    }

    private Certificate[] getCertificateChain() throws KeyStoreException, KeyStoreManagerException {
        KeyStore keyStore = this.getKeyStoreNode().getKeyStore();
        return keyStore.getCertificateChain(this.alias);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.getKeyStoreNode() == null ? 0 : this.getKeyStoreNode().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntryNode)) {
            return false;
        }
        EntryNode other = (EntryNode)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        return !(this.getKeyStoreNode() == null ? other.getKeyStoreNode() != null : !this.getKeyStoreNode().equals(other.getKeyStoreNode()));
    }

    public String toString() {
        return "KeyStoreEntry [alias=" + this.alias + "]";
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getId() {
        return this.alias;
    }

    @Override
    public String getName() {
        return this.alias;
    }

    @Override
    public ImageDescriptor getIcon() {
        ImageDescriptor descr = null;
        descr = this.isPasswordSaved() ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)"icons/key_saved_password.png") : AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)"icons/key.png");
        return descr;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public List<ITreeNode> getChildren() {
        return new ArrayList<ITreeNode>(0);
    }

    public static IKeyStoreEntry createSelfSignedNode(IKeyStore keystore, String keyStorePass, String alias, CertificateDetailsInfo certificateDetailsInfo) throws KeyStoreManagerException {
        KeyPair keyPair = null;
        try {
            keyPair = KeyStoreUtils.genKeyPair();
            X509Certificate x509Certificate = KeyStoreUtils.createX509Certificate(keyPair, certificateDetailsInfo);
            if (keyStorePass == null) {
                PasswordProvider provider = new PasswordProvider(keystore.getFile());
                keyStorePass = provider.getKeyStorePassword(true);
            }
            KeyStore.PrivateKeyEntry privateKeyEntry = KeyStoreUtils.createPrivateKeyEntry(keyPair, x509Certificate);
            KeyStoreUtils.addEntry(keystore.getKeyStore(), keyStorePass.toCharArray(), keystore.getFile(), alias, privateKeyEntry, certificateDetailsInfo.getEntryPassword().toCharArray());
            keystore.forceReload(keyStorePass.toCharArray(), false);
        }
        catch (Exception e) {
            throw new KeyStoreManagerException(e.getMessage(), e);
        }
        return new EntryNode((ITreeNode)((Object)keystore), alias);
    }

    public static IKeyStoreEntry createSelfSignedNode(IKeyStore keystore, String alias, CertificateDetailsInfo certificateDetailsInfo) throws KeyStoreManagerException {
        return EntryNode.createSelfSignedNode(keystore, null, alias, certificateDetailsInfo);
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        boolean result = super.testAttribute(target, name, value);
        if (name.equals("org.eclipse.andmore.android.certmanager.core.property.nodeStatus") && value.equals("org.eclipse.andmore.android.certmanager.core.property.nodeStatusWarning")) {
            X509Certificate x509Certificate = this.getX509Certificate();
            try {
                x509Certificate.checkValidity();
                Calendar date = Calendar.getInstance();
                date.clear();
                date.set(2033, 9, 22);
                x509Certificate.checkValidity(date.getTime());
            }
            catch (CertificateExpiredException certificateExpiredException) {
                this.setTooltip(NLS.bind((String)CertificateManagerNLS.CertificatePeriodExpired_Issue, (Object)x509Certificate.getNotAfter()));
                result = true;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                this.setTooltip(NLS.bind((String)CertificateManagerNLS.CertificatePeriodNotYeatValid_Issue, (Object)x509Certificate.getNotBefore()));
                result = true;
            }
        }
        return result;
    }

    @Override
    public X509Certificate getX509Certificate() {
        X509Certificate x509Certificate = null;
        try {
            if (this.isCertificateEntry()) {
                Certificate cert = this.getCertificate();
                if (cert instanceof X509Certificate) {
                    x509Certificate = (X509Certificate)cert;
                }
            } else if (this.isKeyEntry()) {
                Certificate[] chain = this.getCertificateChain();
                int i = 0;
                while (i < chain.length) {
                    Certificate cert = chain[i];
                    if (cert instanceof X509Certificate) {
                        x509Certificate = (X509Certificate)cert;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            AndmoreLogger.error(EntryNode.class, (String)NLS.bind((String)CertificateManagerNLS.EntryNode_ErrorGettingCertificateFromEntry, (Object)this.getAlias()), (Throwable)e);
        }
        return x509Certificate;
    }

    @Override
    protected boolean isPasswordSaved() {
        PasswordProvider pp = new PasswordProvider(this.getKeyStoreNode().getFile());
        return pp.isPasswordSaved(this.alias);
    }
}

