/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.dialogs;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.composite.KeyPropertiesBlock;
import org.eclipse.andmore.android.certmanager.ui.model.EntryNode;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CertificateInfoDialog
extends Dialog {
    private static final String HELP_ID = "org.eclipse.andmore.android.certmanager.certificate_info_dialog";
    private final KeyPropertiesBlock block;
    private final EntryNode entry;

    public CertificateInfoDialog(Shell parentShell, KeyPropertiesBlock blk, EntryNode entry) {
        super(parentShell);
        this.block = blk;
        this.entry = entry;
    }

    protected Control createContents(Composite parent) {
        if (parent instanceof Shell) {
            ((Shell)parent).setText(CertificateManagerNLS.CertificateInfoDialog_ShellTitle);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        }
        return super.createContents(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite newComposite = (Composite)super.createDialogArea(parent);
        X509Certificate cert = null;
        try {
            cert = this.entry.getX509Certificate();
            if (cert != null) {
                X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
                RDN commonName = x500name.getRDNs(BCStyle.CN).length >= 1 ? x500name.getRDNs(BCStyle.CN)[0] : null;
                RDN organization = x500name.getRDNs(BCStyle.O).length >= 1 ? x500name.getRDNs(BCStyle.O)[0] : null;
                RDN organizationUnit = x500name.getRDNs(BCStyle.OU).length >= 1 ? x500name.getRDNs(BCStyle.OU)[0] : null;
                RDN country = x500name.getRDNs(BCStyle.C).length >= 1 ? x500name.getRDNs(BCStyle.C)[0] : null;
                RDN state = x500name.getRDNs(BCStyle.ST).length >= 1 ? x500name.getRDNs(BCStyle.ST)[0] : null;
                RDN locality = x500name.getRDNs(BCStyle.L).length >= 1 ? x500name.getRDNs(BCStyle.L)[0] : null;
                this.block.createInfoBlock(newComposite, this.entry.getAlias(), this.printCertInfo(commonName), this.printCertInfo(organization), this.printCertInfo(organizationUnit), this.printCertInfo(country), this.printCertInfo(state), this.printCertInfo(locality), cert.getNotAfter(), cert.getNotBefore());
            } else {
                EclipseUtils.showErrorDialog((String)CertificateManagerNLS.CertificateInfoDialog_UnknownCertificateKeypairType, (String)CertificateManagerNLS.CertificatePropertiesHandler_ErrorGettingCertificateOrKeypairProperties);
            }
        }
        catch (Exception e) {
            EclipseUtils.showErrorDialog((String)CertificateManagerNLS.CertificatePropertiesHandler_ErrorGettingCertificateOrKeypairProperties, (String)e.getMessage());
            AndmoreLogger.error(CertificateInfoDialog.class, (String)CertificateManagerNLS.CertificatePropertiesHandler_ErrorGettingCertificateOrKeypairProperties, (Throwable)e);
        }
        return newComposite;
    }

    private String printCertInfo(RDN certItem) {
        return certItem != null ? certItem.getFirst().getValue().toString() : CertificateManagerNLS.CertificateInfoDialog_NotAvailableProperty;
    }
}

