/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.packaging;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.AndroidUtils;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;

public class PackageFile {
    private static final String ANDROID_FEATURE = "org.eclipse.andmore.android.feature";
    private final Map<String, File> entryMap = new HashMap<String, File>();
    private final Map<String, File> tempEntryMap = new HashMap<String, File>();
    private Manifest manifest;
    private int apiVersion;
    private String targetName;
    private Set<String> rawFiles = new HashSet<String>();

    public PackageFile(String createdBy) {
        this.targetName = "";
        this.apiVersion = -1;
        this.manifest = this.createManifest(createdBy);
    }

    public PackageFile(String createdBy, String targetName, int apiVersion) {
        this.targetName = targetName;
        this.apiVersion = apiVersion;
        this.manifest = this.createManifest(createdBy);
    }

    public PackageFile(JarFile jarFile) throws IOException {
        this(jarFile, "", -1);
    }

    public PackageFile(JarFile jarFile, String targetName, int apiVersion) throws IOException {
        this.manifest = jarFile.getManifest();
        this.targetName = targetName;
        this.apiVersion = apiVersion;
        String createdBy = this.generateStudioFingerprint();
        if (this.manifest == null) {
            this.manifest = this.createManifest(createdBy);
        }
        Enumeration<JarEntry> entryEnum = jarFile.entries();
        while (entryEnum.hasMoreElements()) {
            JarEntry entry = entryEnum.nextElement();
            if (entry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
            InputStream is = jarFile.getInputStream(entry);
            File tempFile = File.createTempFile("tmppkg_", null);
            tempFile.deleteOnExit();
            BufferedInputStream bis = null;
            FilterOutputStream bos = null;
            try {
                int c;
                bis = new BufferedInputStream(is);
                bos = new BufferedOutputStream(new FileOutputStream(tempFile));
                while ((c = bis.read()) >= 0) {
                    ((BufferedOutputStream)bos).write(c);
                }
            }
            finally {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            this.setTempEntryFile(entry.getName(), tempFile);
            if (entry.getMethod() != 0) continue;
            this.rawFiles.add(entry.getName());
        }
    }

    private String generateStudioFingerprint() {
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        ArrayList<IBundleGroup> groups = new ArrayList<IBundleGroup>();
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                IBundleGroup[] bundleGroups = providers[i].getBundleGroups();
                groups.addAll(Arrays.asList(bundleGroups));
                ++i;
            }
        }
        String version = "";
        for (IBundleGroup group : groups) {
            if (!group.getIdentifier().equals(ANDROID_FEATURE)) continue;
            version = group.getVersion();
            break;
        }
        StringBuilder stringBuilder = new StringBuilder("Andmore Project");
        stringBuilder.append(" v");
        stringBuilder.append(version);
        stringBuilder.append(" - ");
        stringBuilder.append(Platform.getOS());
        stringBuilder.append(", ");
        stringBuilder.append(Platform.getOSArch());
        stringBuilder.append(". ");
        if (this.targetName.trim().length() > 0) {
            stringBuilder.append("Android target - ");
            stringBuilder.append(this.targetName);
            stringBuilder.append(", ");
        }
        if (this.apiVersion >= 0) {
            stringBuilder.append("API version - ");
            stringBuilder.append(this.apiVersion);
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public Set<String> getEntryNames() {
        return Collections.unmodifiableSet(this.entryMap.keySet());
    }

    public File getEntryFile(String entryName) {
        return this.entryMap.get(entryName);
    }

    public void setEntryFile(String entryName, File file) {
        this.entryMap.put(entryName, file);
    }

    public void setTempEntryFile(String entryName, File tempFile) {
        this.entryMap.put(entryName, tempFile);
        this.tempEntryMap.put(entryName, tempFile);
    }

    public void removeEntryFile(String entryName) throws IOException {
        File entryFile = this.entryMap.get(entryName);
        if (entryFile != null) {
            this.entryMap.remove(entryName);
            if (this.tempEntryMap.containsKey(entryName)) {
                this.tempEntryMap.remove(entryName);
                this.deleteFile(entryFile);
            }
        }
    }

    public void removeMetaEntryFiles() throws IOException {
        String createdBy = this.manifest.getMainAttributes().getValue("Created-By");
        HashSet<String> entries = new HashSet<String>(this.getEntryNames());
        for (String entry : entries) {
            if (!entry.startsWith("META-INF")) continue;
            this.removeEntryFile(entry);
        }
        Manifest cleanManifest = new Manifest();
        cleanManifest.getMainAttributes().putAll((Map<?, ?>)this.manifest.getMainAttributes());
        if ("".equals(this.targetName) && this.apiVersion <= 0) {
            cleanManifest.getMainAttributes().putValue("Created-By", createdBy);
        } else {
            cleanManifest.getMainAttributes().putValue("Created-By", this.generateStudioFingerprint());
        }
        this.manifest = cleanManifest;
    }

    private void writeCompressed(JarOutputStream jarOut, String entryName) throws IOException {
        File file = this.entryMap.get(entryName);
        if (file.exists() && file.isFile()) {
            JarEntry entry = new JarEntry(entryName);
            jarOut.putNextEntry(entry);
            WritableByteChannel outputChannel = null;
            AbstractInterruptibleChannel readFromFileChannel = null;
            FileInputStream inputStream = null;
            try {
                outputChannel = Channels.newChannel(jarOut);
                inputStream = new FileInputStream(file);
                readFromFileChannel = inputStream.getChannel();
                ((FileChannel)readFromFileChannel).transferTo(0L, file.length(), outputChannel);
            }
            finally {
                try {
                    if (jarOut != null) {
                        jarOut.closeEntry();
                    }
                    if (readFromFileChannel != null) {
                        readFromFileChannel.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)"Could not close stream: ", (String)e.getMessage());
                }
            }
        }
    }

    private void writeRaw(JarOutputStream jarOut, String entryName) throws IOException {
        FileInputStream inputStream = null;
        File file = this.entryMap.get(entryName);
        if (file.exists() && file.isFile()) {
            CRC32 crc = new CRC32();
            JarEntry entry = new JarEntry(entryName);
            entry.setMethod(0);
            entry.setSize(file.length());
            WritableByteChannel outputChannel = null;
            AbstractInterruptibleChannel readFromFileChannel = null;
            try {
                outputChannel = Channels.newChannel(jarOut);
                inputStream = new FileInputStream(file);
                readFromFileChannel = inputStream.getChannel();
                ByteBuffer buffer = ByteBuffer.allocate(0x100000);
                crc.reset();
                while (((FileChannel)readFromFileChannel).read(buffer) > 0) {
                    buffer.flip();
                    byte[] byteArray = new byte[buffer.limit()];
                    buffer.get(byteArray, 0, buffer.limit());
                    crc.update(byteArray);
                    buffer.clear();
                }
                entry.setCrc(crc.getValue());
                jarOut.putNextEntry(entry);
                ((FileChannel)readFromFileChannel).transferTo(0L, file.length(), outputChannel);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (readFromFileChannel != null) {
                    readFromFileChannel.close();
                }
                jarOut.closeEntry();
            }
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        JarOutputStream jarOut = null;
        try {
            jarOut = new JarOutputStream(outputStream, this.manifest);
            for (String jarEntryName : this.entryMap.keySet()) {
                if (jarEntryName.contains("raw/") || this.rawFiles.contains(jarEntryName)) {
                    this.writeRaw(jarOut, jarEntryName);
                    continue;
                }
                this.writeCompressed(jarOut, jarEntryName);
            }
        }
        finally {
            if (jarOut != null) {
                try {
                    jarOut.finish();
                    jarOut.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close stream while writing jar file. " + e.getMessage()));
                }
            }
        }
    }

    public long getTotalSize() {
        long totalSize = 0L;
        for (String jarEntryName : this.entryMap.keySet()) {
            File file = this.entryMap.get(jarEntryName);
            if (!file.exists() || !file.isFile()) continue;
            totalSize += file.length();
        }
        return totalSize;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void removeTemporaryEntryFiles() throws IOException {
        HashSet<String> tempEntries = new HashSet<String>(Collections.unmodifiableSet(this.tempEntryMap.keySet()));
        for (String tempEntry : tempEntries) {
            this.removeEntryFile(tempEntry);
        }
    }

    private void deleteFile(File fileToDelete) throws IOException {
        if (!(fileToDelete != null && fileToDelete.exists() && fileToDelete.isFile() && fileToDelete.canWrite())) {
            String errorMessage = "";
            if (fileToDelete == null) {
                errorMessage = "Null pointer for file to delete.";
            } else if (!fileToDelete.exists()) {
                errorMessage = "The file " + fileToDelete.getName() + " does not exist.";
            } else if (!fileToDelete.isFile()) {
                errorMessage = String.valueOf(fileToDelete.getName()) + " is not a file.";
            } else if (!fileToDelete.canWrite()) {
                errorMessage = "Cannot write to " + fileToDelete.getName();
            }
            throw new IOException("Cannot delete file: " + errorMessage);
        }
        fileToDelete.delete();
    }

    public Manifest createManifest(String createdBy) {
        Manifest newManifest = new Manifest();
        Attributes mainAttributes = newManifest.getMainAttributes();
        mainAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        mainAttributes.putValue("Created-By", createdBy);
        return newManifest;
    }

    public static void zipAlign(File apk) {
        String zipAlign = String.valueOf(AndroidUtils.getSDKPathByPreference()) + '/' + "tools";
        try {
            File tempFile = File.createTempFile("_tozipalign", ".apk");
            FileUtil.copyFile((File)apk, (File)tempFile);
            if (!zipAlign.endsWith(File.separator)) {
                zipAlign = String.valueOf(zipAlign) + File.separator;
            }
            zipAlign = String.valueOf(zipAlign) + (Platform.getOS().equals("win32") ? "zipalign.exe" : "zipalign");
            String[] command = new String[]{zipAlign, "-f", "-v", "4", tempFile.getAbsolutePath(), apk.getAbsolutePath()};
            StringBuilder commandLine = new StringBuilder();
            String[] stringArray = command;
            int n = command.length;
            int n2 = 0;
            while (n2 < n) {
                String commandPart = stringArray[n2];
                commandLine.append(commandPart);
                commandLine.append(" ");
                ++n2;
            }
            AndmoreLogger.info(PackageFile.class, (String)("Zipaligning package: " + commandLine.toString()));
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            AndmoreLogger.error(PackageFile.class, (String)"Error while zipaligning package", (Throwable)e);
        }
        catch (Exception e) {
            AndmoreLogger.error(PackageFile.class, (String)"Zipalign application cannot be executed - insuficient permissions", (Throwable)e);
        }
    }
}

