/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.command;

import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import org.eclipse.andmore.android.certmanager.command.AbstractHandler2;
import org.eclipse.andmore.android.certmanager.core.KeyStoreUtils;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEvent;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEventManager;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.EntryNode;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.ui.PasswordInputDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.PlatformUI;

public class ChangePasswordKeyHandler
extends AbstractHandler2
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITreeNode entry = this.getSelection().get(0);
        if (entry instanceof EntryNode) {
            KeyStoreNode keyStoreNode = (KeyStoreNode)entry.getParent();
            PasswordProvider passwordProvider = new PasswordProvider(keyStoreNode.getFile());
            EntryNode entryNode = (EntryNode)entry;
            PasswordInputDialog passwordInputDialog = null;
            boolean cancelledOrChangedPassword = false;
            do {
                if ((passwordInputDialog = new PasswordInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), CertificateManagerNLS.PasswordInput_EnterOldKeyPasssword_Message, true, null, 6)).open() == 0) {
                    String newPassword = passwordInputDialog.getNewPassword();
                    String oldPassword = passwordInputDialog.getOldPassword();
                    if (newPassword == null || oldPassword == null) continue;
                    try {
                        KeyStore.Entry keyEntry = entryNode.getKeyEntry(oldPassword);
                        if (keyEntry == null) continue;
                        boolean tryAgain = false;
                        boolean useSavedPass = true;
                        String keystorePassword = null;
                        KeyStore keyStore = null;
                        do {
                            if (tryAgain) {
                                useSavedPass = false;
                            }
                            keystorePassword = passwordProvider.getKeyStorePassword(true, useSavedPass);
                            tryAgain = false;
                            if (keystorePassword == null) continue;
                            try {
                                if (keyStoreNode.isPasswordValid(keystorePassword)) {
                                    keyStore = keyStoreNode.getKeyStore(keystorePassword);
                                    continue;
                                }
                                tryAgain = true;
                            }
                            catch (InvalidPasswordException invalidPasswordException) {
                                tryAgain = true;
                            }
                        } while (tryAgain);
                        if (keyStore == null) continue;
                        KeyStoreUtils.changeEntryPassword(keyStore, keystorePassword.toCharArray(), keyStoreNode.getFile(), entryNode.getAlias(), keyEntry, newPassword.toCharArray());
                        if (passwordProvider.isPasswordSaved(entryNode.getAlias())) {
                            passwordProvider.deleteSavedPassword(entryNode.getAlias());
                        }
                        if (passwordInputDialog.needToStorePassword()) {
                            passwordProvider.savePassword(entryNode.getAlias(), newPassword);
                        }
                        cancelledOrChangedPassword = true;
                        EclipseUtils.showInformationDialog((String)CertificateManagerNLS.PasswordChanged_Info_Title, (String)CertificateManagerNLS.PasswordChanged_KeyInfo_Message);
                        KeyStoreModelEventManager.getInstance().fireEvent(entryNode, KeyStoreModelEvent.EventType.UPDATE);
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        cancelledOrChangedPassword = false;
                        EclipseUtils.showErrorDialog((String)CertificateManagerNLS.ChangePasswordKeyHandler_Error_WrongOldKeyPassword, (String)CertificateManagerNLS.ChangePasswordKeyHandler_Wrong_Key_Password);
                    }
                    catch (Exception e) {
                        cancelledOrChangedPassword = false;
                        EclipseUtils.showErrorDialog((String)CertificateManagerNLS.ChangePasswordKeyHandler_Error_WrongOldKeyPassword, (String)e.getMessage());
                    }
                    continue;
                }
                cancelledOrChangedPassword = true;
            } while (!cancelledOrChangedPassword);
        }
        return null;
    }
}

