/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ide;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.eclipse.amp.escape.ide.PluginProjectWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PluginTemplateProjectWizard
extends PluginProjectWizard {
    public void createFiles() throws CoreException, IOException {
        IFolder mFolder = this.getProject().getFolder("META-INF");
        mFolder.create(true, true, null);
        this.copyFiles((IPath)new Path("res/MANIFEST_TEMPLATE.MF"), (IPath)new Path("META-INF/MANIFEST.MF"), new StringPair[]{new StringPair("%project_name%", this.getProject().getName()), new StringPair("%project_symbol%", this.getProject().getName())});
        this.copyFiles((IPath)new Path("res/build_template.properties"), (IPath)new Path("build.properties"), new StringPair[0]);
    }

    public void copyFiles(IPath srcFileLoc, IPath destFileLoc, StringPair[] pairs) throws CoreException, IOException {
        InputStream srcStream = this.streamFromPlugin(this.getPluginID(), srcFileLoc.toString());
        BufferedReader srcReader = new BufferedReader(new InputStreamReader(srcStream));
        StringBuffer buffer = new StringBuffer();
        String next = srcReader.readLine();
        while (next != null) {
            buffer.append(String.valueOf(next) + "\r\n");
            next = srcReader.readLine();
        }
        String parsedText = buffer.toString();
        StringPair[] stringPairArray = pairs;
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            StringPair p = stringPairArray[n2];
            parsedText = StringUtils.replace((String)parsedText, (String)p.a, (String)p.b);
            ++n2;
        }
        StringBufferInputStream is = new StringBufferInputStream(parsedText);
        IFile destFile = this.getProject().getFile(destFileLoc);
        destFile.create((InputStream)is, true, null);
    }

    public InputStream streamFromPlugin(String pluginID, String path) {
        try {
            Bundle bundle = Platform.getBundle((String)pluginID);
            URL entry = bundle.getEntry(path);
            if (entry == null) {
                throw new RuntimeException("No resource:" + path + " found in plugin: " + pluginID);
            }
            return entry.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't load project resource from plugin.", e);
        }
    }

    protected class StringPair {
        public String a;
        public String b;

        public StringPair(String a, String b) {
            this.a = a;
            this.b = b;
        }
    }
}

